@extends('layouts.dashboard.app')

@section('content')

    <div class="content-wrapper">

        <section class="content-header">

            <h1>@lang('site.mouncercats')</h1>

            <ol class="breadcrumb">
                <li><a href="{{ route('dashboard.welcome') }}"><i class="fa fa-dashboard"></i> @lang('site.dashboard')</a></li>
                <li class="active">@lang('site.mouncercats')</li>
            </ol>
        </section>

        <section class="content">

            <div class="box box-primary">

                <div class="box-header with-border">

                    <h3 class="box-title" style="margin-bottom: 15px">@lang('site.mouncercats')</h3>
               <div class="row">
                   <div class="col-md-4">
                                    @if (auth()->user()->hasPermission('create_mouncerfatcat'))
                                
                                        <a href="{{ route('mouncerfatcats.create') }}" class="btn btn-primary"><i class="fa fa-plus"></i> @lang('site.add')</a>
                                    @else
                                         <a href="#" class="btn btn-primary disabled"><i class="fa fa-plus"></i> @lang('site.add')</a>
                                    @endif
                     </div>
                 </div><!-- end of row--> 
                </div><!-- end of box header -->

<div class="box-body">

@if ($mouncerfatcats->count() > 0)

    <table class="table table-hover">

        <thead>
        <tr> 
            <th>#</th>
            <th>@lang('site.name')</th>
            <th>@lang('site.action')</th>
        </tr>
        </thead>
        
        <tbody>
        @foreach ($mouncerfatcats as $index=>$mouncerfatcat)
            <tr>

                <td>{{ $index + 1 }}</td>
                <td>{{ $mouncerfatcat->name }}</td>
                <td>
                    @if (auth()->user()->hasPermission('update_mouncerfatcat'))
                        <a href="{{ route('mouncerfatcats.edit', $mouncerfatcat->id) }}" class="btn btn-info btn-sm"><i class="fa fa-edit"></i> @lang('site.edit')</a>
                    @else
                        <a href="#" class="btn btn-info btn-sm disabled"><i class="fa fa-edit"></i> @lang('site.edit')</a>
                    @endif
                     @if (auth()->user()->hasPermission('delete_mouncerfatcat'))
                        <form action="{{ route('mouncerfatcats.destroy', $mouncerfatcat->id) }}" method="post" style="display: inline-block">
                            {{ csrf_field() }}
                            {{ method_field('delete') }}
                            <button type="submit" class="btn btn-danger delete btn-sm"><i class="fa fa-trash"></i> @lang('site.delete')</button>
                        </form><!-- end of form -->
                    @else
                        <button class="btn btn-danger btn-sm disabled"><i class="fa fa-trash"></i> @lang('site.delete')</button>
                    @endif
                </td>
            </tr>
        
        @endforeach
        </tbody>

    </table><!-- end of table -->
    
   
                        
                    @else
                        
                        <h2>@lang('site.no_data_found')</h2>
                        
                    @endif

                </div><!-- end of box body -->


            </div><!-- end of box -->

        </section><!-- end of content -->

    </div><!-- end of content wrapper -->


@endsection
