<?php

use Illuminate\Support\Facades\Route;

    Route::get('registration', 'Auth\RegisterController@registration')->name('registration');
	
	
	//Route::post('reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');

	Route::get('my-captcha', 'HomeController@myCaptcha')->name('myCaptcha');
    Route::post('my-captcha', 'HomeController@myCaptchaPost')->name('myCaptcha.post');
    Route::get('refresh_captcha', 'HomeController@refreshCaptcha')->name('refresh_captcha');

Route::group(['middleware'=>['guest']],function(){

	Route::get('/', function()
	{
	return view('auth.login');
	 });

});

Auth::routes(['verify' => true]);

Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
		'middleware' => [ 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath', 'auth' ]
	], function()
	{ 
	
		Route::get('/dashboard', 'HomeController@index')->name('dashboard');

		Route::resource('years', 'YearController');
		//==============================users============================

		Route::resource('users', 'UserController');
		Route::get('logout','UserController@userLogout')->name('userLogout');
		Route::get('/changePassword','UserController@showChangePasswordForm')->name('changePassword');
		Route::post('/changePassword','UserController@changePassword')->name('changePassword');
		//==============================attachment============================ 
		Route::post('Upload_attachment', 'UserController@Upload_attachment')->name('Upload_attachment');
        Route::get('Download_attachment/{user_id}/{filename}', 'UserController@Download_attachment')->name('Download_attachment');
        Route::post('Delete_attachment', 'UserController@Delete_attachment')->name('Delete_attachment');
		 //===========================roles============================
		 Route::resource('roles','RoleController');
		 //===========================patients============================
		 Route::resource('patients','PatientController');
		 //===========================diseases============================
		 Route::resource('diseases','DiseaseController');
		 //===========================symptoms============================
		 Route::resource('symptoms','SymptomController');
		 //===========================records============================
		 Route::resource('records','RecordController');
		 //===========================locations============================
		 Route::resource('locations','LocationController');
        //===========================exports============================ 
		 Route::get('exportPatients', 'PatientController@exportPatients');
		 Route::get('exportRecords', 'RecordController@exportRecords');



	});