@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Users_trans.users') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0">{{ trans('Users_trans.users') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ trans('Users_trans.users') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul> 
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <a href="{{ route('users.create') }}">
                    <button type="button" class="button x-small">
                        {{ trans('Users_trans.add_User') }}
                    </button>
                    <br><br> 
                </a>
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Users_trans.name') }}</th>
                                <th>{{ trans('Users_trans.email') }}</th>
                                <th>{{ trans('Users_trans.dept') }}</th>
                                <th>{{ trans('Users_trans.user_type') }}</th>
                                <th>{{ trans('Users_trans.Processes') }}</th>

                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($users as $index => $user)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $user->first_name }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td>{{ $user->dept->name }}</td>
                                    <td>
                                        @if ($user->user_type == 'admin')
                                            {{ trans('Users_trans.admin') }}
                                        @else
                                            {{ trans('Users_trans.user') }}
                                        @endif
                                    </td>
                                    
                                   <td width="100">
                                        @can('عرض مستخدم')
                                        <a href="{{ route('users.show', encrypt($user->id)) }}">
                                            <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                            
                                            title="{{ trans('Statment_trans.show') }}"><i
                                                class="fa fa-eye"></i></button>
                                           </a>
                                         @endcan
                                         @can('تعديل مستخدم')
                                        <a href="{{ route('users.edit', encrypt($user->id)) }}">
                                            <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            
                                            title="{{ trans('Statment_trans.Edit') }}"><i
                                                class="fa fa-edit"></i></button>
                                           </a>
                                         @endcan
                                         @can('حذف مستخدم')
                                        <button type="button" class="btn btn-danger btn-sm" data-toggle="modal"
                                            data-target="#del{{ $user->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>
                                         @endcan
                                    </td>
                                </tr>
                                <!-- delete_modal_user -->
                                <div class="modal fade" id="del{{ $user->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['users.destroy', $user->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $user->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>



</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
