@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
{{ trans('Report_trans.title_page') }} - {{ trans('Record_trans.statments') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Statment_trans.title_page') }} / {{ trans('Certificat_trans.reports') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.reports') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </a>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{trans('Certificat_trans.notification_number')}}</th>
                               
                                @can('المالية')
                                <th>{{ trans('Statment_trans.Pay_process') }}</th>
                                @endcan
                                @can('النتيجة')
                                <th>{{ trans('Statment_trans.Result_process') }}</th>
                                @endcan
                                <th>{{ trans('Certificat_trans.date') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($statments as $index => $statment)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $statment->first_name }} {{ $statment->second_name }} {{ $statment->midell_name }} {{ $statment->last_name }}</td>
                                    
                                    <td>{{ $statment->notification_number }}</td>
                                    @can('المالية')
                                    <td>
                                        @if ($statment->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($statment->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    @endcan
                                    @can('النتيجة')
                                    <td>
                                        @if ($statment->r_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($statment->r_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    @endcan
                                    <td>
                                        {{ date('d-m-y', strtotime($statment->created_at)) }}
                                     </td>
                                </tr>

                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
