@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{trans('Students_trans.Student_details')}}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
    {{trans('Students_trans.Student_details')}}
@stop
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">
                    <div class="card-body">
                        <div class="tab nav-border">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active show" id="home-02-tab" data-toggle="tab" href="#home-02"
                                       role="tab" aria-controls="home-02"
                                       aria-selected="true">{{trans('Students_trans.Student_details')}}</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="profile-02-tab" data-toggle="tab" href="#profile-02"
                                       role="tab" aria-controls="profile-02"
                                       aria-selected="false">{{trans('Students_trans.Attachments')}}</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade active show" id="home-02" role="tabpanel"
                                     aria-labelledby="home-02-tab">
                                    <table class="table table-striped table-hover" style="text-align:center">
                                        <tbody>
                                        <tr>
                                            <th scope="row">{{trans('Certificat_trans.First_name')}}</th>
                                            <td>{{ $certificat->first_name }} </td>
                                            <th scope="row">{{trans('Certificat_trans.Second_name')}}</th>
                                            <td>{{ $certificat->second_name }}</td>
                                            <th scope="row">{{trans('Certificat_trans.Third_name')}}</th>
                                            <td>{{ $certificat->midell_name }}</td>
                                            <th scope="row">{{trans('Certificat_trans.Last_name')}}</th>
                                            <td>{{ $certificat->last_name }}</td>
                                        </tr>
                                        
                                        <tr>
                                            
                                            <th scope="row">{{trans('Depts_trans.Name_Dept')}}</th>
                                            <td>{{ $certificat->dept->name }}</td>
                                            <th scope="row">{{trans('Certificat_trans.certificat_type')}}</th>
                                            <td>
                                                @if ($certificat->certificat_type == '1')
                                                {{ trans('Certificat_trans.Details') }}
                                                @else
                                                        {{ trans('Certificat_trans.Regular') }}
                                                @endif
                                            </td>
                                            <th scope="row">{{trans('Certificat_trans.admission_year')}}</th>
                                            <td>{{ $certificat->admission_year }}</td>
                                            <th scope="row">{{trans('Certificat_trans.guraduate_year')}}</th>
                                            <td>{{ $certificat->guraduate_year }}</td>
                                        </tr>

                                      
                                        </tbody>
                                    </table>
                                </div>

                                <div class="tab-pane fade" id="profile-02" role="tabpanel"
                                     aria-labelledby="profile-02-tab">
                                    <div class="card card-statistics">
                                        <div class="card-body">
                                            {{-- <form method="post" action="#" enctype="multipart/form-data">
                                                {{ csrf_field() }}
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label
                                                            for="academic_year">{{trans('Students_trans.Attachments')}}
                                                            : <span class="text-danger">*</span></label>
                                                        <input type="file" accept="image/*" name="photos[]" multiple required>
                                                        <input type="hidden" name="student_name" value="1">
                                                        <input type="hidden" name="student_id" value="2">
                                                    </div>
                                                </div>
                                                <br><br>
                                                <button type="submit" class="button button-border x-small">
                                                       {{trans('Students_trans.submit')}}
                                                </button>
                                            </form> --}}
                                        </div>
                                        <br>
                                        <table class="table center-aligned-table mb-0 table table-hover"
                                               style="text-align:center">
                                            <thead>
                                            <tr class="table-secondary">
                                             
                                            </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <img src="{{ asset('images/personalImage/' . $certificat->personal_image )}}">
                                                    </td>
                                                    <td>
                                                        <img src="{{ asset('images/bank/' . $certificat->bank )}}">
                                                    </td>
                                                </tr>
                                               <tr>
                                                <td>
                                                    <img src="{{ asset('images/ssn/' . $certificat->ssn )}}">
                                                </td>
                                                <td>
                                                    <img src="{{ asset('images/schoolCertificat/' . $certificat->school_certificat )}}">
                                                </td>
                                               </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
