@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
    <!-- breadcrumb -->
@section('PageTitle')
سند قبض 
@stop
<!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                   
                            {!! Form::model($certificat, ['method' => 'PATCH','files' => 'ture','route' => ['certificats.update', $certificat->id]]) !!}
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Depts_trans.Name_Dept') }} : <span class="text-danger">*</span></label>
                                        <select name="dept_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($depts as $dept)
                                            <option value='{{ $dept->id}}'{{$dept->id == $certificat->dept_id ? 'selected' : '' }}> {{ $dept->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.certificat_type') }} : <span class="text-danger">*</span></label>
                                        <select name="certificat_type" id="select-beast" class="form-control custom-select">
                                            <option value="" selected disabled>{{ trans('main_trans.Choose') }} </option>
                                                <option value='1' {{ $certificat->certificat_type == '1' ? 'selected' : '' }}>  {{ trans('Certificat_trans.Details') }} </option>
                                                <option value='2' {{ $certificat->certificat_type == '2' ? 'selected' : '' }}> {{ trans('Certificat_trans.Regular') }} </option>
                                            </select>
                                        </select>             

                                    </div>
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.First_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ $certificat->first_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Second_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="second_name" type="text" value="{{ $certificat->second_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Third_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="midell_name" type="text" value="{{ $certificat->midell_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.Last_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="last_name" type="text" value="{{ $certificat->last_name }}">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.admission_year') }} : <span class="text-danger">*</span></label>
                                        <select name="admission_year" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($years as $year)
                                            <option value='{{ $year->name}}'{{$year->name == $certificat->admission_year ? 'selected' : '' }}> {{ $year->name}}</option>
                                            @endforeach

                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Certificat_trans.guraduate_year') }} : <span class="text-danger">*</span></label>
                                        <select name="guraduate_year" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example">
                                            <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                            @foreach($years as $year)
                                            <option value='{{ $year->name}}'{{$year->name == $certificat->guraduate_year ? 'selected' : '' }}> {{ $year->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="personal_image">{{trans('Certificat_trans.personal_image')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="personal_image" class="dropify"
                                        accept=".pdf,.jpg, .png, image/jpeg, image/png" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept=".pdf,.jpg, .png, image/jpeg, image/png" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="ssn">{{trans('Certificat_trans.ssn')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="ssn" class="dropify"
                                        accept=".pdf,.jpg, .png, image/jpeg, image/png" data-height="70" />
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="school_certificat">{{trans('Certificat_trans.school_certificat')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="school_certificat" class="dropify"
                                        accept=".pdf,.jpg, .png, image/jpeg, image/png" data-height="70" />
                                    </div>
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-md-3">
                                    <button class="btn btn-success btn-lg nextBtn btn-lg pull-right" type="submit">{{trans('Certificat_trans.submit')}}</button>
                                </div>
                            </div>
                            
                        </form>

                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
