@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Document_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0">{{ trans('Certificat_trans.reports') }} / {{ trans('Document_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Document_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{trans('Certificat_trans.amount')}}</th>
                                <th>{{trans('Certificat_trans.notification_number')}}</th>
                                {{-- <th>{{ trans('Depts_trans.Name_Dept') }}</th> --}}
                                <th>{{ trans('Certificat_trans.date') }}</th>
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <th>{{ trans('Certificat_trans.bank_note') }}</th>
                               
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($documents as $index => $document)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $document->user->first_name }}</td>
                                    <td>{{ $document->amount }}</td>
                                    <td>{{ $document->notification_number }}</td>
                                    {{-- <td>{{ $document->user->dept->name }}</td> --}}
                                    <td>{{ date('d-m-y', strtotime($document->created_at)) }}</td>
                                    <td>
                                        @if ($document->certificat->certificat_type == ["1"])
                                        {{ trans('Certificat_trans.Details') }}
                                        @elseif ($document->certificat->certificat_type == ["2"])
                                        {{ trans('Certificat_trans.Regular') }}
                                        @else
                                          {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                        @endif
                                    </td>
                                    <td>
                                        @if ($document->f_status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($document->f_status == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                 
                                </tr>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')


@toastr_js
@toastr_render
@endsection
