@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    وزارة الصحة الولائية - اعرض الوبائيات
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> وزارة الصحة الولائية - اعرض الوبائيات</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> وزارة الصحة الولائية - اعرض الوبائيات</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="button" class="button x-small" data-toggle="modal" data-target="#exampleModal">
                    اضافة عرض جديد
                </button>
                <br><br>

                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>اسم العرض</th>
                                <th>اسم الوباء</th>
                                <th>تاريخ التسجيل</th>
                                <th>العمليات</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($symptoms as $index => $symptom)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $symptom->desc }}</td>
                                    <td>{{ $symptom->disease->name }}</td>
                                    <td>{{ $symptom->created_at }}</td>
                                    <td>

                                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            data-target="#edit{{ $symptom->id }}"
                                            title="{{ trans('Depts_trans.Edit') }}"><i class="fa fa-edit">
                                                تعديل</i></button>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="{{ $symptom->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i class="fa fa-trash">
                                                حذف</i></button>

                                    </td>
                                </tr>

                                <!-- Edit_modal_Subject -->
                                <div class="modal fade" id="edit{{ $symptom->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    تعديل عرض
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">

                                                {!! Form::model($symptom, ['route' => ['symptoms.update', $symptom->id], 'method' => 'PUT']) !!}
                                                @csrf
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2">الاعراض :</label>
                                                        <textarea name="desc" id="" rows="4" class="form-control">{{ $symptom->desc }} </textarea>

                                                        <input id="id" type="hidden" name="id"
                                                            class="form-control" value="{{ $symptom->id }}">
                                                    </div>

                                                </div>
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2">اسم الوباء :</label>
                                                        <select name="disease_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>

                                                            @foreach ($diseases as $disease)
                                                                <option
                                                                    value='{{ $disease->id }}'{{ $disease->id == $symptom->disease_id ? 'selected' : '' }}>
                                                                    {{ $disease->name }}</option>
                                                            @endforeach

                                                        </select>

                                                    </div>
                                                </div>
                                                <br><br>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    حذف الوباء
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['symptoms.destroy', $symptom->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title" id="exampleModalLabel">
                        اضافة عرض جديد
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- add_form -->
                    <form action="{{ route('symptoms.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الاعراض
                                    :</label>
                                <textarea name="desc" id="" rows="4" class="form-control"></textarea>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col">
                                <label for="Name" class="mr-sm-2">اسم الوباء :</label>
                                <select name="disease_id" id="lab" class="custom-select" class="custom-select"
                                    aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}
                                    </option>
                                    @foreach ($diseases as $key => $disease)
                                        <option value="{{ $disease->id }}">
                                            {{ $disease->name }}</option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                        <br><br>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                    <button type="submit" class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                </div>
                </form>

            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

@toastr_js
@toastr_render
@endsection
