@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    وزارة الصحة الولائية - سجلات المرضى
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> وزارة الصحة الولائية - سجلات المرضى</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> وزارة الصحة الولائية - سجلات المرضى</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="button" class="button x-small" data-toggle="modal" data-target="#exampleModal">
                    اضافة سجل جديد
                </button>
                <a class="btn btn-warning"
                href="{{ url('exportRecords') }}">
                       تصدير
                </a>
                <br><br>

                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>اسم المريض</th>
                                <th>الوباء</th>
                                <th>الحالة</th>
                                <th>الموقع</th>
                                <th>تاريخ التشخيص</th>
                                <th>الوصف</th>
                                <th>العمليات</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($records as $index => $record)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $record->patient->name }}</td>
                                    <td>{{ $record->disease->name }}</td>
                                    <td>
                                        @if ($record->stauts == '0')
                                            <span class="label text-success">
                                                <strong>معافى</strong>
                                            </span>
                                        @elseif ($record->stauts == '1')
                                            <span class="label text-info">
                                                <strong>مشتبة به</strong>
                                            </span>
                                        @elseif ($record->stauts == '3')
                                            <span class="label text-danger">
                                                <strong>مؤكد</strong>
                                            </span>
                                        @else
                                            <span class="label text-danger">
                                                <strong>متوفي</strong>
                                            </span>
                                        @endif
                                    </td>
                                    <td>{{ $record->location->name }}</td>
                                    <td>{{ $record->diagnosis_date }}</td>

                                    <td>{{ $record->desc }}</td>
                                    <td>

                                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            data-target="#edit{{ $record->id }}"
                                            title="{{ trans('Depts_trans.Edit') }}"><i class="fa fa-edit">
                                                تعديل</i></button>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="{{ $record->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i class="fa fa-trash">
                                                حذف</i></button>

                                    </td>
                                </tr>

                                <!-- Edit_modal_Subject -->
                                <div class="modal fade" id="edit{{ $record->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    تعديل سجل مريض
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- add_form -->
                                                {!! Form::model($record, ['route' => ['records.update', $record->id], 'method' => 'PUT']) !!}
                                                @csrf
                                                <div class="row">
                                                    <div class="col">
                                                        <input id="id" type="hidden" name="id"
                                                            class="form-control" value="{{ $record->id }}">
                                                        <label for="Name" class="mr-sm-2">اسم مريض :</label>
                                                        <select name="patient_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($patients as $patient)
                                                                <option
                                                                    value='{{ $patient->id }}'{{ $patient->id == $record->patient_id ? 'selected' : '' }}>
                                                                    {{ $patient->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> الوباء :</label>
                                                        <select name="disease_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($diseases as $disease)
                                                                <option
                                                                    value='{{ $disease->id }}'{{ $disease->id == $record->disease_id ? 'selected' : '' }}>
                                                                    {{ $disease->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> الموقع :</label>
                                                        <select name="location_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($locations as $location)
                                                                <option
                                                                    value='{{ $location->id }}'{{ $location->id == $record->location_id ? 'selected' : '' }}>
                                                                    {{ $location->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                {{-- <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> التاريخ :</label>
                                                        <input class="form-control fc-datepicker"
                                                            value="{{ $record->diagnosis_date }}" name="diagnosis_date"
                                                            type="text" required>
                                                    </div>

                                                </div> --}}
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="name" class="mr-sm-2"> الوصف :</label>
                                                        <textarea name="desc" id="" rows="4" class="form-control">{{ $record->desc }}</textarea>
                                                    </div>
                                                </div>

                                                <br><br>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    حذف سجل مريض
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['records.destroy', $record->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title" id="exampleModalLabel">
                        اضافة سجل جديد
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- add_form -->
                    <form action="{{ route('records.store') }}" method="POST">
                        @csrf
                        <!-- row 1 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2">اسم المريض :</label>
                                <select name="patient_id" class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($patients as $patient)
                                        <option value="{{ $patient->id }}">{{ $patient->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الوباء :</label>
                                <select name="disease_id" class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($diseases as $disease)
                                        <option value="{{ $disease->id }}">{{ $disease->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الموقع :</label>
                                <select name="location_id" class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($locations as $location)
                                        <option value="{{ $location->id }}">{{ $location->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- row 2 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> تاريخ التشخيص :</label>
                                <input class="form-control fc-datepicker" value="{{ old('diagnosis_date') }}"
                                    name="diagnosis_date" placeholder="YYYY-MM-DD" type="text" required>
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الحالة :</label>
                                <select name="stauts" class="custom-select"aria-label="Default select example">
                                    <option value="0">معافى</option>
                                    <option value="1">مشتبه به</option>
                                    <option value="2">مؤكد</option>
                                    <option value="3">متوفي</option>
                                </select>
                            </div>
                        </div>

                        <!-- row 3 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الوصف :</label>
                                <textarea name="desc" id="" rows="4" class="form-control"></textarea>
                            </div>
                        </div>
                        <br><br>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                    <button type="submit" class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                </div>
                </form>

            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
<!--Internal  Datepicker js -->
<script src="{{ URL::asset('assets/plugins/jquery-ui/ui/widgets/datepicker.js') }}"></script>
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>
<script>
    var date = $('.fc-datepicker').datepicker({
        dateFormat: 'yy-mm-dd'
    }).val();
</script>

@toastr_js
@toastr_render
@endsection
