@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    وزارة الصحة الولائية - بيانات المرضى
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> وزارة الصحة الولائية - بيانات المرضى</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> وزارة الصحة الولائية - بيانات المرضى</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="button" class="button x-small" data-toggle="modal" data-target="#exampleModal">
                    اضافة مريض جديد
                </button>
                <a class="btn btn-warning"
                href="{{ url('exportPatients') }}">
                       تصدير
                </a>

                <br><br>

                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>اسم المريض</th>
                                <th>العمر</th>
                                <th>الجنسية</th>
                                <th>فصيلة الدم</th>
                                <th>النوع</th>
                                {{-- <th>رقم الهاتف</th>
                                <th>العنوان</th>
                                <th>الرقم الوطني</th> --}}
                                <th>العمليات</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($patients as $index => $patient)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $patient->name }}</td>
                                    <td>{{ $patient->age }}</td>
                                    <td>{{ $patient->nationalitie->name }}</td>
                                    <td>{{ $patient->blood->name }}</td>
                                    <td>{{ $patient->gender->name }}</td>
                                    {{-- <td>{{ $patient->phone }}</td>
                                    <td>{{ $patient->address }}</td>
                                    <td>{{ $patient->ssn }}</td> --}}
                                    <td>

                                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            data-target="#edit{{ $patient->id }}"
                                            title="{{ trans('Depts_trans.Edit') }}"><i class="fa fa-edit">
                                                تعديل</i></button>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="{{ $patient->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i class="fa fa-trash">
                                                حذف</i></button>

                                    </td>
                                </tr>

                                <!-- Edit_modal_Subject -->
                                <div class="modal fade" id="edit{{ $patient->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    تعديل مريض
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- add_form -->
                                                {!! Form::model($patient, ['route' => ['patients.update', $patient->id], 'method' => 'PUT']) !!}
                                                @csrf
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2">اسم مريض :</label>
                                                        <input id="Name" type="text" name="name"
                                                            class="form-control" value="{{ $patient->name }}" required>
                                                        <input id="id" type="hidden" name="id"
                                                            class="form-control" value="{{ $patient->id }}">
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> العمر :</label>
                                                        <input id="Name" type="number" name="age"
                                                            class="form-control" value="{{ $patient->age }}" required>
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> النوع :</label>
                                                        <select name="gender_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($genders as $gender)
                                                                <option
                                                                    value='{{ $gender->id }}'{{ $gender->id == $patient->gender_id ? 'selected' : '' }}>
                                                                    {{ $gender->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> الجنسية :</label>
                                                        <select name="nationalitie_id" id="lab"
                                                            class="custom-select" class="custom-select"
                                                            aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($nationalities as $nationalitie)
                                                                <option
                                                                    value='{{ $nationalitie->id }}'{{ $nationalitie->id == $patient->nationalitie_id ? 'selected' : '' }}>
                                                                    {{ $nationalitie->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> فصيلة الدم :</label>
                                                        <select name="blood_id" id="lab" class="custom-select"
                                                            class="custom-select" aria-label="Default select example">
                                                            <option selected disabled>{{ trans('main_trans.Choose') }}
                                                            </option>
                                                            @foreach ($bloods as $blood)
                                                                <option
                                                                    value='{{ $blood->id }}'{{ $blood->id == $patient->blood_id ? 'selected' : '' }}>
                                                                    {{ $blood->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> رقم الهاتف :</label>
                                                        <input id="Name" type="text" name="phone"
                                                            class="form-control" value="{{ $patient->phone }}"
                                                            required>
                                                    </div>
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2"> الرقم الوطني :</label>
                                                        <input id="Name" type="number" name="ssn"
                                                            class="form-control" value="{{ $patient->ssn }}"
                                                            required>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="name" class="mr-sm-2"> العنوان :</label>
                                                        <textarea name="address" id="" rows="4" class="form-control">{{ $patient->address }}</textarea>
                                                    </div>

                                                </div>

                                                <br><br>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    حذف مريض
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['patients.destroy', $patient->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title" id="exampleModalLabel">
                        اضافة مريض جديد
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <!-- add_form -->
                    <form action="{{ route('patients.store') }}" method="POST">
                        @csrf
                        <!-- row 1 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2">اسم المريض :</label>
                                <input id="name" type="text" name="name" class="form-control">
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> العمر :</label>
                                <input id="name" type="number" name="age" class="form-control">
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> النوع :</label>
                                <select name="gender_id" class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($genders as $gender)
                                        <option value="{{ $gender->id }}">{{ $gender->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- row 2 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الجنسية :</label>
                                <select name="nationalitie_id"
                                    class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($nationalities as $nationalitie)
                                        <option value="{{ $nationalitie->id }}">{{ $nationalitie->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> فصيلة الدم :</label>
                                <select name="blood_id" class="custom-select"aria-label="Default select example">
                                    <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                    @foreach ($bloods as $blood)
                                        <option value="{{ $blood->id }}">{{ $blood->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <!-- row 3 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> رقم الهاتف :</label>
                                <input id="name" type="number" name="phone" class="form-control">
                            </div>
                            <div class="col">
                                <label for="name" class="mr-sm-2"> الرقم الوطني :</label>
                                <input id="name" type="number" name="ssn" class="form-control">
                            </div>
                        </div>
                        <!-- row 3 -->
                        <div class="row">
                            <div class="col">
                                <label for="name" class="mr-sm-2"> العنوان :</label>
                                <textarea name="address" id="" rows="4" class="form-control"></textarea>
                            </div>

                        </div>

                        <br><br>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                    <button type="submit" class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                </div>
                </form>

            </div>
        </div>
    </div>


</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

@toastr_js
@toastr_render
@endsection
