@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    وزارة الصحة الولائية - المواقع
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> وزارة الصحة الولائية - المواقع</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> وزارة الصحة الولائية - المواقع</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <button type="button" class="button x-small" data-toggle="modal" data-target="#exampleModal">
                    اضافة موقع جديد
                </button>
                 <br><br>

                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>اسم الموقع</th>
                                <th>تاريخ التسجيل</th>
                                <th>العمليات</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($locations as $index => $location)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $location->name }}</td>
                                    <td>{{ $location->created_at }}</td>
                                    <td>

                                        <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            data-target="#edit{{ $location->id }}"
                                            title="{{ trans('Depts_trans.Edit') }}"><i class="fa fa-edit">
                                                تعديل</i></button>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="{{ $location->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i class="fa fa-trash">
                                                حذف</i></button>

                                    </td>
                                </tr>

                                <!-- Edit_modal_Subject -->
                                <div class="modal fade" id="edit{{ $location->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    تعديل موقع
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <!-- add_form -->
                                                {!! Form::model($location, ['route' => ['locations.update', $location->id], 'method' => 'PUT']) !!}
                                                @csrf
                                                <div class="row">
                                                    <div class="col">
                                                        <label for="Name" class="mr-sm-2">اسم الموقع:</label>
                                                        <input id="Name" type="text" name="name"
                                                            class="form-control" value="{{ $location->name }}" required>
                                                        <input id="id" type="hidden" name="id"
                                                            class="form-control" value="{{ $location->id }}">
                                                    </div>
                                                </div>
                                                <br><br>

                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    حذف موقع
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['locations.destroy', $location->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
aria-hidden="true">
<div class="modal-dialog" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title" id="exampleModalLabel">
                اضافة موقع جديد
            </h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <div class="modal-body">
            <!-- add_form -->
            <form action="{{ route('locations.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col">
                        <label for="name" class="mr-sm-2">اسم الموقع
                            :</label>
                        <input id="name" type="text" name="name" class="form-control">
                    </div>
                    
                </div>

                <br><br>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary"
                data-dismiss="modal">{{ trans('Depts_trans.Close') }}</button>
            <button type="submit" class="btn btn-success">{{ trans('Depts_trans.submit') }}</button>
        </div>
        </form>

    </div>
</div>
</div>


</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

@toastr_js
@toastr_render
@endsection
