<!DOCTYPE html>
<html lang="en">
<title>{{ trans('main_trans.Dashboard') }}</title>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="كلية الامارات للعلوم و التكنولوجيا" />
    <meta name="description" content="كلية الامارات للعلوم و التكنولوجيا - نظام الشهادات" />
    <meta name="author" content="www.eust.edu.sd" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    @include('layouts.head')
</head>

<body>

    <div class="wrapper">

        <!--=================================
 preloader -->

        <div id="pre-loader">
            <img src="assets/images/pre-loader/loader-01.svg" alt="">
        </div>

        <!--=================================
 preloader -->

        @include('layouts.main-header')

        @include('layouts.main-sidebar')

        <!--=================================
 Main content -->
        <!-- main-content -->
        <div class="content-wrapper">
            <div class="page-title">

            </div>
            <!-- widgets -->

            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-danger">
                                        <i class="fa fa-user-o highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">المرضى</p>
                                    <h4>{{ number_format(\App\Models\Patient::count('id')) }}</h4>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-warning">
                                        <i class="ti-id-badge highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">عدد سجلات المرضى</p>
                                    <h4>{{ number_format(\App\Models\Record::count('id')) }}</h4>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-success">
                                        <i class="fa fa-server highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">عدد الوبائيات</p>
                                    <h4> {{ number_format(\App\Models\Disease::count('id')) }}</h4>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-primary">
                                        <i class="fa fa-address-book highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark">المواقع</p>
                                    <h4>{{ number_format(\App\Models\Location::count('id')) }}</h4>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>


            <!-- Orders Status widgets-->

            <div class="row">
                <div class="col-xl-12">
                    <div class="card h-100">
                        <div class="card-header">
                            <div class="card-title">تقرير فيروس كرونا رقم (168) في الفترة من 28 يناير و حتي يوم 10
                                اكتوبر 2020م
                            </div>
                        </div>
                        <div class="card-body">
                            <div>
                                <div style="height: 320px;"><svg id="SvgjsSvg3122" width="549" height="320"
                                        xmlns="http://www.w3.org/2000/svg" version="1.1"
                                        xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:svgjs="http://svgjs.dev"
                                        class="apexcharts-svg" xmlns:data="ApexChartsNS" transform="translate(0, 0)"
                                        style="background: transparent;">
                                        <g id="SvgjsG3124" class="apexcharts-inner apexcharts-graphical"
                                            transform="translate(106.88333129882812, 30)">
                                            <defs id="SvgjsDefs3123">
                                                <linearGradient id="SvgjsLinearGradient3127" x1="0"
                                                    y1="0" x2="0" y2="1">
                                                    <stop id="SvgjsStop3128" stop-opacity="0.4"
                                                        stop-color="rgba(216,227,240,0.4)" offset="0"></stop>
                                                    <stop id="SvgjsStop3129" stop-opacity="0.5"
                                                        stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                    <stop id="SvgjsStop3130" stop-opacity="0.5"
                                                        stop-color="rgba(190,209,230,0.5)" offset="1"></stop>
                                                </linearGradient>
                                                <clipPath id="gridRectMaskjc0w8ye2">
                                                    <rect id="SvgjsRect3132" width="422.8833351135254"
                                                        height="255.584" x="-2" y="0" rx="0" ry="0"
                                                        opacity="1" stroke-width="0" stroke="none"
                                                        stroke-dasharray="0" fill="#fff"></rect>
                                                </clipPath>
                                                <clipPath id="forecastMaskjc0w8ye2"></clipPath>
                                                <clipPath id="nonForecastMaskjc0w8ye2"></clipPath>
                                                <clipPath id="gridRectMarkerMaskjc0w8ye2">
                                                    <rect id="SvgjsRect3133" width="422.8833351135254"
                                                        height="259.584" x="-2" y="-2" rx="0" ry="0"
                                                        opacity="1" stroke-width="0" stroke="none"
                                                        stroke-dasharray="0" fill="#fff"></rect>
                                                </clipPath>
                                            </defs>
                                            <rect id="SvgjsRect3131" width="0" height="255.584" x="0" y="0"
                                                rx="0" ry="0" opacity="1" stroke-width="0"
                                                stroke-dasharray="3" fill="url(#SvgjsLinearGradient3127)"
                                                class="apexcharts-xcrosshairs" y2="255.584" filter="none"
                                                fill-opacity="0.9"></rect>
                                            <line id="SvgjsLine3163" x1="0" y1="256.584" x2="0"
                                                y2="262.584" stroke="#e0e0e0" stroke-dasharray="0"
                                                stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                            <line id="SvgjsLine3164" x1="84.07666702270508" y1="256.584"
                                                x2="84.07666702270508" y2="262.584" stroke="#e0e0e0"
                                                stroke-dasharray="0" stroke-linecap="butt"
                                                class="apexcharts-xaxis-tick"></line>
                                            <line id="SvgjsLine3165" x1="168.1533340454102" y1="256.584"
                                                x2="168.1533340454102" y2="262.584" stroke="#e0e0e0"
                                                stroke-dasharray="0" stroke-linecap="butt"
                                                class="apexcharts-xaxis-tick"></line>
                                            <line id="SvgjsLine3166" x1="252.23000106811529" y1="256.584"
                                                x2="252.23000106811529" y2="262.584" stroke="#e0e0e0"
                                                stroke-dasharray="0" stroke-linecap="butt"
                                                class="apexcharts-xaxis-tick"></line>
                                            <line id="SvgjsLine3167" x1="336.3066680908204" y1="256.584"
                                                x2="336.3066680908204" y2="262.584" stroke="#e0e0e0"
                                                stroke-dasharray="0" stroke-linecap="butt"
                                                class="apexcharts-xaxis-tick"></line>
                                            <line id="SvgjsLine3168" x1="420.38333511352545" y1="256.584"
                                                x2="420.38333511352545" y2="262.584" stroke="#e0e0e0"
                                                stroke-dasharray="0" stroke-linecap="butt"
                                                class="apexcharts-xaxis-tick"></line>
                                            <g id="SvgjsG3159" class="apexcharts-grid">
                                                <g id="SvgjsG3160" class="apexcharts-gridlines-horizontal">
                                                    <line id="SvgjsLine3170" x1="0" y1="25.5584"
                                                        x2="418.8833351135254" y2="25.5584" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3171" x1="0" y1="51.1168"
                                                        x2="418.8833351135254" y2="51.1168" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3172" x1="0" y1="76.67519999999999"
                                                        x2="418.8833351135254" y2="76.67519999999999"
                                                        stroke="#f2f5f7" stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3173" x1="0" y1="102.2336"
                                                        x2="418.8833351135254" y2="102.2336" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3174" x1="0" y1="127.792"
                                                        x2="418.8833351135254" y2="127.792" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3175" x1="0" y1="153.3504"
                                                        x2="418.8833351135254" y2="153.3504" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3176" x1="0" y1="178.9088"
                                                        x2="418.8833351135254" y2="178.9088" stroke="#f2f5f7"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3177" x1="0" y1="204.46720000000002"
                                                        x2="418.8833351135254" y2="204.46720000000002"
                                                        stroke="#f2f5f7" stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                    <line id="SvgjsLine3178" x1="0" y1="230.02560000000003"
                                                        x2="418.8833351135254" y2="230.02560000000003"
                                                        stroke="#f2f5f7" stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-gridline"></line>
                                                </g>
                                                <g id="SvgjsG3161" class="apexcharts-gridlines-vertical"></g>
                                                <line id="SvgjsLine3181" x1="0" y1="255.584"
                                                    x2="418.8833351135254" y2="255.584" stroke="transparent"
                                                    stroke-dasharray="0" stroke-linecap="butt"></line>
                                                <line id="SvgjsLine3180" x1="0" y1="1"
                                                    x2="0" y2="255.584" stroke="transparent"
                                                    stroke-dasharray="0" stroke-linecap="butt"></line>
                                            </g>
                                            <g id="SvgjsG3162" class="apexcharts-grid-borders">
                                                <line id="SvgjsLine3169" x1="0" y1="0"
                                                    x2="418.8833351135254" y2="0" stroke="#f2f5f7"
                                                    stroke-dasharray="0" stroke-linecap="butt"
                                                    class="apexcharts-gridline"></line>
                                                <line id="SvgjsLine3179" x1="0" y1="255.58400000000003"
                                                    x2="418.8833351135254" y2="255.58400000000003" stroke="#f2f5f7"
                                                    stroke-dasharray="0" stroke-linecap="butt"
                                                    class="apexcharts-gridline"></line>
                                                <line id="SvgjsLine3204" x1="0" y1="255.584"
                                                    x2="418.8833351135254" y2="255.584" stroke="#e0e0e0"
                                                    stroke-dasharray="0" stroke-width="1" stroke-linecap="butt">
                                                </line>
                                                <line id="SvgjsLine3237" x1="0" y1="1"
                                                    x2="0" y2="255.584" stroke="#e0e0e0"
                                                    stroke-dasharray="0" stroke-linecap="butt"></line>
                                            </g>
                                            <g id="SvgjsG3134" class="apexcharts-bar-series apexcharts-plot-series">
                                                <g id="SvgjsG3135" class="apexcharts-series" rel="1"
                                                    seriesName="series-1" data:realIndex="0">
                                                    <path id="SvgjsPath3140"
                                                        d="M 4.101 3.83376 L 107.80322269694011 3.83376 C 109.80322269694011 3.83376 111.80322269694011 5.83376 111.80322269694011 7.83376 L 111.80322269694011 17.72464 C 111.80322269694011 19.72464 109.80322269694011 21.72464 107.80322269694011 21.72464 L 4.101 21.72464 C 2.101 21.72464 0.101 19.72464 0.101 17.72464 L 0.101 7.83376 C 0.101 5.83376 2.101 3.83376 4.101 3.83376 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 3.83376 L 107.80322269694011 3.83376 C 109.80322269694011 3.83376 111.80322269694011 5.83376 111.80322269694011 7.83376 L 111.80322269694011 17.72464 C 111.80322269694011 19.72464 109.80322269694011 21.72464 107.80322269694011 21.72464 L 4.101 21.72464 C 2.101 21.72464 0.101 19.72464 0.101 17.72464 L 0.101 7.83376 C 0.101 5.83376 2.101 3.83376 4.101 3.83376 Z "
                                                        pathFrom="M 0.101 3.83376 L 0.101 3.83376 L 0.101 21.72464 L 0.101 21.72464 L 0.101 21.72464 L 0.101 21.72464 L 0.101 21.72464 L 0.101 3.83376 Z"
                                                        cy="29.392159999999997" cx="111.8022226969401" j="0"
                                                        val="400" barHeight="17.89088"
                                                        barWidth="111.70222269694011"></path>
                                                    <path id="SvgjsPath3142"
                                                        d="M 4.101 29.392159999999997 L 116.18088939921061 29.392159999999997 C 118.18088939921061 29.392159999999997 120.18088939921061 31.392159999999997 120.18088939921061 33.39216 L 120.18088939921061 43.28304 C 120.18088939921061 45.28304 118.18088939921061 47.28304 116.18088939921061 47.28304 L 4.101 47.28304 C 2.101 47.28304 0.101 45.28304 0.101 43.28304 L 0.101 33.39216 C 0.101 31.392159999999997 2.101 29.392159999999997 4.101 29.392159999999997 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 29.392159999999997 L 116.18088939921061 29.392159999999997 C 118.18088939921061 29.392159999999997 120.18088939921061 31.392159999999997 120.18088939921061 33.39216 L 120.18088939921061 43.28304 C 120.18088939921061 45.28304 118.18088939921061 47.28304 116.18088939921061 47.28304 L 4.101 47.28304 C 2.101 47.28304 0.101 45.28304 0.101 43.28304 L 0.101 33.39216 C 0.101 31.392159999999997 2.101 29.392159999999997 4.101 29.392159999999997 Z "
                                                        pathFrom="M 0.101 29.392159999999997 L 0.101 29.392159999999997 L 0.101 47.28304 L 0.101 47.28304 L 0.101 47.28304 L 0.101 47.28304 L 0.101 47.28304 L 0.101 29.392159999999997 Z"
                                                        cy="54.950559999999996" cx="120.17988939921061" j="1"
                                                        val="430" barHeight="17.89088"
                                                        barWidth="120.07988939921061"></path>
                                                    <path id="SvgjsPath3144"
                                                        d="M 4.101 54.950559999999996 L 121.20748942057291 54.950559999999996 C 123.20748942057291 54.950559999999996 125.20748942057291 56.950559999999996 125.20748942057291 58.950559999999996 L 125.20748942057291 68.84143999999999 C 125.20748942057291 70.84143999999999 123.20748942057291 72.84143999999999 121.20748942057291 72.84143999999999 L 4.101 72.84143999999999 C 2.101 72.84143999999999 0.101 70.84143999999999 0.101 68.84143999999999 L 0.101 58.950559999999996 C 0.101 56.950559999999996 2.101 54.950559999999996 4.101 54.950559999999996 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 54.950559999999996 L 121.20748942057291 54.950559999999996 C 123.20748942057291 54.950559999999996 125.20748942057291 56.950559999999996 125.20748942057291 58.950559999999996 L 125.20748942057291 68.84143999999999 C 125.20748942057291 70.84143999999999 123.20748942057291 72.84143999999999 121.20748942057291 72.84143999999999 L 4.101 72.84143999999999 C 2.101 72.84143999999999 0.101 70.84143999999999 0.101 68.84143999999999 L 0.101 58.950559999999996 C 0.101 56.950559999999996 2.101 54.950559999999996 4.101 54.950559999999996 Z "
                                                        pathFrom="M 0.101 54.950559999999996 L 0.101 54.950559999999996 L 0.101 72.84143999999999 L 0.101 72.84143999999999 L 0.101 72.84143999999999 L 0.101 72.84143999999999 L 0.101 72.84143999999999 L 0.101 54.950559999999996 Z"
                                                        cy="80.50896" cx="125.20648942057291" j="2" val="448"
                                                        barHeight="17.89088" barWidth="125.10648942057291"></path>
                                                    <path id="SvgjsPath3146"
                                                        d="M 4.101 80.50896 L 127.35111166890462 80.50896 C 129.35111166890462 80.50896 131.35111166890462 82.50896 131.35111166890462 84.50896 L 131.35111166890462 94.39984 C 131.35111166890462 96.39984 129.35111166890462 98.39984 127.35111166890462 98.39984 L 4.101 98.39984 C 2.101 98.39984 0.101 96.39984 0.101 94.39984 L 0.101 84.50896 C 0.101 82.50896 2.101 80.50896 4.101 80.50896 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 80.50896 L 127.35111166890462 80.50896 C 129.35111166890462 80.50896 131.35111166890462 82.50896 131.35111166890462 84.50896 L 131.35111166890462 94.39984 C 131.35111166890462 96.39984 129.35111166890462 98.39984 127.35111166890462 98.39984 L 4.101 98.39984 C 2.101 98.39984 0.101 96.39984 0.101 94.39984 L 0.101 84.50896 C 0.101 82.50896 2.101 80.50896 4.101 80.50896 Z "
                                                        pathFrom="M 0.101 80.50896 L 0.101 80.50896 L 0.101 98.39984 L 0.101 98.39984 L 0.101 98.39984 L 0.101 98.39984 L 0.101 98.39984 L 0.101 80.50896 Z"
                                                        cy="106.06736000000001" cx="131.35011166890462" j="3"
                                                        val="470" barHeight="17.89088"
                                                        barWidth="131.25011166890462"></path>
                                                    <path id="SvgjsPath3148"
                                                        d="M 4.101 106.06736000000001 L 146.89900064086913 106.06736000000001 C 148.89900064086913 106.06736000000001 150.89900064086913 108.06736000000001 150.89900064086913 110.06736000000001 L 150.89900064086913 119.95824 C 150.89900064086913 121.95824 148.89900064086913 123.95824 146.89900064086913 123.95824 L 4.101 123.95824 C 2.101 123.95824 0.101 121.95824 0.101 119.95824 L 0.101 110.06736000000001 C 0.101 108.06736000000001 2.101 106.06736000000001 4.101 106.06736000000001 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 106.06736000000001 L 146.89900064086913 106.06736000000001 C 148.89900064086913 106.06736000000001 150.89900064086913 108.06736000000001 150.89900064086913 110.06736000000001 L 150.89900064086913 119.95824 C 150.89900064086913 121.95824 148.89900064086913 123.95824 146.89900064086913 123.95824 L 4.101 123.95824 C 2.101 123.95824 0.101 121.95824 0.101 119.95824 L 0.101 110.06736000000001 C 0.101 108.06736000000001 2.101 106.06736000000001 4.101 106.06736000000001 Z "
                                                        pathFrom="M 0.101 106.06736000000001 L 0.101 106.06736000000001 L 0.101 123.95824 L 0.101 123.95824 L 0.101 123.95824 L 0.101 123.95824 L 0.101 123.95824 L 0.101 106.06736000000001 Z"
                                                        cy="131.62576" cx="150.89800064086913" j="4" val="540"
                                                        barHeight="17.89088" barWidth="150.79800064086913"></path>
                                                    <path id="SvgjsPath3150"
                                                        d="M 4.101 131.62576 L 158.06922291056316 131.62576 C 160.06922291056316 131.62576 162.06922291056316 133.62576 162.06922291056316 135.62576 L 162.06922291056316 145.51664000000002 C 162.06922291056316 147.51664000000002 160.06922291056316 149.51664000000002 158.06922291056316 149.51664000000002 L 4.101 149.51664000000002 C 2.101 149.51664000000002 0.101 147.51664000000002 0.101 145.51664000000002 L 0.101 135.62576 C 0.101 133.62576 2.101 131.62576 4.101 131.62576 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 131.62576 L 158.06922291056316 131.62576 C 160.06922291056316 131.62576 162.06922291056316 133.62576 162.06922291056316 135.62576 L 162.06922291056316 145.51664000000002 C 162.06922291056316 147.51664000000002 160.06922291056316 149.51664000000002 158.06922291056316 149.51664000000002 L 4.101 149.51664000000002 C 2.101 149.51664000000002 0.101 147.51664000000002 0.101 145.51664000000002 L 0.101 135.62576 C 0.101 133.62576 2.101 131.62576 4.101 131.62576 Z "
                                                        pathFrom="M 0.101 131.62576 L 0.101 131.62576 L 0.101 149.51664000000002 L 0.101 149.51664000000002 L 0.101 149.51664000000002 L 0.101 149.51664000000002 L 0.101 149.51664000000002 L 0.101 131.62576 Z"
                                                        cy="157.18416000000002" cx="162.06822291056315" j="5"
                                                        val="580" barHeight="17.89088"
                                                        barWidth="161.96822291056316"></path>
                                                    <path id="SvgjsPath3152"
                                                        d="M 4.101 157.18416000000002 L 188.7873341522217 157.18416000000002 C 190.7873341522217 157.18416000000002 192.7873341522217 159.18416000000002 192.7873341522217 161.18416000000002 L 192.7873341522217 171.07504000000003 C 192.7873341522217 173.07504000000003 190.7873341522217 175.07504000000003 188.7873341522217 175.07504000000003 L 4.101 175.07504000000003 C 2.101 175.07504000000003 0.101 173.07504000000003 0.101 171.07504000000003 L 0.101 161.18416000000002 C 0.101 159.18416000000002 2.101 157.18416000000002 4.101 157.18416000000002 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 157.18416000000002 L 188.7873341522217 157.18416000000002 C 190.7873341522217 157.18416000000002 192.7873341522217 159.18416000000002 192.7873341522217 161.18416000000002 L 192.7873341522217 171.07504000000003 C 192.7873341522217 173.07504000000003 190.7873341522217 175.07504000000003 188.7873341522217 175.07504000000003 L 4.101 175.07504000000003 C 2.101 175.07504000000003 0.101 173.07504000000003 0.101 171.07504000000003 L 0.101 161.18416000000002 C 0.101 159.18416000000002 2.101 157.18416000000002 4.101 157.18416000000002 Z "
                                                        pathFrom="M 0.101 157.18416000000002 L 0.101 157.18416000000002 L 0.101 175.07504000000003 L 0.101 175.07504000000003 L 0.101 175.07504000000003 L 0.101 175.07504000000003 L 0.101 175.07504000000003 L 0.101 157.18416000000002 Z"
                                                        cy="182.74256000000003" cx="192.78633415222168" j="6"
                                                        val="690" barHeight="17.89088"
                                                        barWidth="192.6863341522217"></path>
                                                    <path id="SvgjsPath3154"
                                                        d="M 4.101 182.74256000000003 L 303.2821124165853 182.74256000000003 C 305.2821124165853 182.74256000000003 307.2821124165853 184.74256000000003 307.2821124165853 186.74256000000003 L 307.2821124165853 196.63344000000004 C 307.2821124165853 198.63344000000004 305.2821124165853 200.63344000000004 303.2821124165853 200.63344000000004 L 4.101 200.63344000000004 C 2.101 200.63344000000004 0.101 198.63344000000004 0.101 196.63344000000004 L 0.101 186.74256000000003 C 0.101 184.74256000000003 2.101 182.74256000000003 4.101 182.74256000000003 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 182.74256000000003 L 303.2821124165853 182.74256000000003 C 305.2821124165853 182.74256000000003 307.2821124165853 184.74256000000003 307.2821124165853 186.74256000000003 L 307.2821124165853 196.63344000000004 C 307.2821124165853 198.63344000000004 305.2821124165853 200.63344000000004 303.2821124165853 200.63344000000004 L 4.101 200.63344000000004 C 2.101 200.63344000000004 0.101 198.63344000000004 0.101 196.63344000000004 L 0.101 186.74256000000003 C 0.101 184.74256000000003 2.101 182.74256000000003 4.101 182.74256000000003 Z "
                                                        pathFrom="M 0.101 182.74256000000003 L 0.101 182.74256000000003 L 0.101 200.63344000000004 L 0.101 200.63344000000004 L 0.101 200.63344000000004 L 0.101 200.63344000000004 L 0.101 200.63344000000004 L 0.101 182.74256000000003 Z"
                                                        cy="208.30096000000003" cx="307.2811124165853" j="7"
                                                        val="1100" barHeight="17.89088"
                                                        barWidth="307.1811124165853"></path>
                                                    <path id="SvgjsPath3156"
                                                        d="M 4.101 208.30096000000003 L 331.20766809082033 208.30096000000003 C 333.20766809082033 208.30096000000003 335.20766809082033 210.30096000000003 335.20766809082033 212.30096000000003 L 335.20766809082033 222.19184000000004 C 335.20766809082033 224.19184000000004 333.20766809082033 226.19184000000004 331.20766809082033 226.19184000000004 L 4.101 226.19184000000004 C 2.101 226.19184000000004 0.101 224.19184000000004 0.101 222.19184000000004 L 0.101 212.30096000000003 C 0.101 210.30096000000003 2.101 208.30096000000003 4.101 208.30096000000003 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 208.30096000000003 L 331.20766809082033 208.30096000000003 C 333.20766809082033 208.30096000000003 335.20766809082033 210.30096000000003 335.20766809082033 212.30096000000003 L 335.20766809082033 222.19184000000004 C 335.20766809082033 224.19184000000004 333.20766809082033 226.19184000000004 331.20766809082033 226.19184000000004 L 4.101 226.19184000000004 C 2.101 226.19184000000004 0.101 224.19184000000004 0.101 222.19184000000004 L 0.101 212.30096000000003 C 0.101 210.30096000000003 2.101 208.30096000000003 4.101 208.30096000000003 Z "
                                                        pathFrom="M 0.101 208.30096000000003 L 0.101 208.30096000000003 L 0.101 226.19184000000004 L 0.101 226.19184000000004 L 0.101 226.19184000000004 L 0.101 226.19184000000004 L 0.101 226.19184000000004 L 0.101 208.30096000000003 Z"
                                                        cy="233.85936000000004" cx="335.20666809082036" j="8"
                                                        val="1200" barHeight="17.89088"
                                                        barWidth="335.10666809082034"></path>
                                                    <path id="SvgjsPath3158"
                                                        d="M 4.101 233.85936000000004 L 381.4736683044434 233.85936000000004 C 383.4736683044434 233.85936000000004 385.4736683044434 235.85936000000004 385.4736683044434 237.85936000000004 L 385.4736683044434 247.75024000000005 C 385.4736683044434 249.75024000000005 383.4736683044434 251.75024000000005 381.4736683044434 251.75024000000005 L 4.101 251.75024000000005 C 2.101 251.75024000000005 0.101 249.75024000000005 0.101 247.75024000000005 L 0.101 237.85936000000004 C 0.101 235.85936000000004 2.101 233.85936000000004 4.101 233.85936000000004 Z "
                                                        fill="rgba(1,98,232,0.85)" fill-opacity="1"
                                                        stroke-opacity="1" stroke-linecap="round" stroke-width="0"
                                                        stroke-dasharray="0" class="apexcharts-bar-area"
                                                        index="0" clip-path="url(#gridRectMaskjc0w8ye2)"
                                                        pathTo="M 4.101 233.85936000000004 L 381.4736683044434 233.85936000000004 C 383.4736683044434 233.85936000000004 385.4736683044434 235.85936000000004 385.4736683044434 237.85936000000004 L 385.4736683044434 247.75024000000005 C 385.4736683044434 249.75024000000005 383.4736683044434 251.75024000000005 381.4736683044434 251.75024000000005 L 4.101 251.75024000000005 C 2.101 251.75024000000005 0.101 249.75024000000005 0.101 247.75024000000005 L 0.101 237.85936000000004 C 0.101 235.85936000000004 2.101 233.85936000000004 4.101 233.85936000000004 Z "
                                                        pathFrom="M 0.101 233.85936000000004 L 0.101 233.85936000000004 L 0.101 251.75024000000005 L 0.101 251.75024000000005 L 0.101 251.75024000000005 L 0.101 251.75024000000005 L 0.101 251.75024000000005 L 0.101 233.85936000000004 Z"
                                                        cy="259.41776000000004" cx="385.4726683044434" j="9"
                                                        val="1380" barHeight="17.89088"
                                                        barWidth="385.3726683044434"></path>

                                                    <g id="SvgjsG3138"
                                                        class="apexcharts-bar-shadows apexcharts-hidden-element-shown">
                                                    </g>
                                                </g>

                                            </g>
                                            <line id="SvgjsLine3182" x1="0" y1="0"
                                                x2="418.8833351135254" y2="0" stroke="#b6b6b6"
                                                stroke-dasharray="0" stroke-width="1" stroke-linecap="butt"
                                                class="apexcharts-ycrosshairs"></line>
                                            <line id="SvgjsLine3183" x1="0" y1="0"
                                                x2="418.8833351135254" y2="0" stroke-dasharray="0"
                                                stroke-width="0" stroke-linecap="butt"
                                                class="apexcharts-ycrosshairs-hidden"></line>
                                            <g id="SvgjsG3205" class="apexcharts-yaxis apexcharts-xaxis-inversed"
                                                rel="0">
                                                <g id="SvgjsG3206"
                                                    class="apexcharts-yaxis-texts-g apexcharts-xaxis-inversed-texts-g"
                                                    transform="translate(0, 0)"><text id="SvgjsText3208"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="13.940945454545455" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3209">النيل الابيض</tspan>
                                                        <title>النيل الابيض</title>
                                                    </text><text id="SvgjsText3211"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="39.499345454545455" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3212">النيل الازرق</tspan>
                                                        <title>النيل الازرق</title>
                                                    </text><text id="SvgjsText3214"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="65.05774545454545" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3215">نهر النيل</tspan>
                                                        <title>نهر النيل</title>
                                                    </text><text id="SvgjsText3217"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="90.61614545454546" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3218">الشمالية</tspan>
                                                        <title>الشمالية</title>
                                                    </text><text id="SvgjsText3220"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="116.17454545454547" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3221">كسلا</tspan>
                                                        <title>كسلا</title>
                                                    </text><text id="SvgjsText3223"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="141.73294545454547" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3224">القضارف</tspan>
                                                        <title>القضارف</title>
                                                    </text><text id="SvgjsText3226"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="167.29134545454548" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3227">سنار</tspan>
                                                        <title>سنار</title>
                                                    </text><text id="SvgjsText3229"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="192.84974545454548" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3230">البحر الاحمر</tspan>
                                                        <title>البحر الاحمر</title>
                                                    </text><text id="SvgjsText3232"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="218.4081454545455" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3233">نهر النيل</tspan>
                                                        <title>نهر النيل</title>
                                                    </text><text id="SvgjsText3235"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        y="243.9665454545455" text-anchor="end"
                                                        dominant-baseline="auto" font-size="14px" font-weight="600"
                                                        fill="#ffffff"
                                                        class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label">
                                                        <tspan id="SvgjsTspan3236">شمال كردفان</tspan>
                                                        <title>شمال كردفان</title>
                                                    </text></g>
                                            </g>
                                            <g id="SvgjsG3184" class="apexcharts-xaxis apexcharts-yaxis-inversed">
                                                <g id="SvgjsG3185" class="apexcharts-xaxis-texts-g"
                                                    transform="translate(0, -7.333333333333333)"><text
                                                        id="SvgjsText3186" font-family="Helvetica, Arial, sans-serif"
                                                        x="418.8833351135254" y="285.584" text-anchor="middle"
                                                        dominant-baseline="auto" font-size="11px" font-weight="600"
                                                        fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3188">1500</tspan>
                                                        <title>1500</title>
                                                    </text><text id="SvgjsText3189"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        x="335.0066680908203" y="285.584" text-anchor="middle"
                                                        dominant-baseline="auto" font-size="11px" font-weight="600"
                                                        fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3191">1200</tspan>
                                                        <title>1200</title>
                                                    </text><text id="SvgjsText3192"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        x="251.13000106811523" y="285.584" text-anchor="middle"
                                                        dominant-baseline="auto" font-size="11px" font-weight="600"
                                                        fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3194">900</tspan>
                                                        <title>900</title>
                                                    </text><text id="SvgjsText3195"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        x="167.25333404541016" y="285.584" text-anchor="middle"
                                                        dominant-baseline="auto" font-size="11px" font-weight="600"
                                                        fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3197">600</tspan>
                                                        <title>600</title>
                                                    </text><text id="SvgjsText3198"
                                                        font-family="Helvetica, Arial, sans-serif"
                                                        x="83.37666702270508" y="285.584" text-anchor="middle"
                                                        dominant-baseline="auto" font-size="11px" font-weight="600"
                                                        fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3200">300</tspan>
                                                        <title>300</title>
                                                    </text><text id="SvgjsText3201"
                                                        font-family="Helvetica, Arial, sans-serif" x="-0.5" y="285.584"
                                                        text-anchor="middle" dominant-baseline="auto"
                                                        font-size="11px" font-weight="600" fill="#8c9097"
                                                        class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                        style="font-family: Helvetica, Arial, sans-serif;">
                                                        <tspan id="SvgjsTspan3203">0</tspan>
                                                        <title>0</title>
                                                    </text></g>
                                            </g>

                                        </g>
                                    </svg>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="calendar-main mb-30">
                <div class="row">
                    <div class="col-xl-12 mb-30">
                        <div class="col-xl-6">
                            <div class="card custom-card">
                                <div class="card-header">
                                    <div class="card-title">رسم بياني يوضح انتشار كوفيد حسب الشهر</div>
                                </div>
                                <div class="card-body">
                                    <div id="line-chart" style="min-height: 335px;">
                                        <div id="apexchartswvnj37m5"
                                            class="apexcharts-canvas apexchartswvnj37m5 apexcharts-theme-light"
                                            style="width: 549px; height: 320px;"><svg id="SvgjsSvg1001"
                                                width="549" height="320" xmlns="http://www.w3.org/2000/svg"
                                                version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink"
                                                xmlns:svgjs="http://svgjs.dev" class="apexcharts-svg"
                                                xmlns:data="ApexChartsNS" transform="translate(0, 0)"
                                                style="background: transparent;">
                                                <foreignObject x="0" y="0" width="549" height="320">
                                                    <div class="apexcharts-legend"
                                                        xmlns="http://www.w3.org/1999/xhtml"
                                                        style="max-height: 160px;"></div>
                                                </foreignObject>
                                                <rect id="SvgjsRect1007" width="0" height="0" x="0" y="0"
                                                    rx="0" ry="0" opacity="1" stroke-width="0"
                                                    stroke="none" stroke-dasharray="0" fill="#fefefe"></rect>
                                                <g id="SvgjsG1069" class="apexcharts-yaxis" rel="0"
                                                    transform="translate(16.966659545898438, 0)">
                                                    <g id="SvgjsG1070" class="apexcharts-yaxis-texts-g"><text
                                                            id="SvgjsText1072"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="52.5333251953125" text-anchor="end"
                                                            dominant-baseline="auto" font-size="11px"
                                                            font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1073">150</tspan>
                                                            <title>150</title>
                                                        </text><text id="SvgjsText1075"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="99.44346015625" text-anchor="end"
                                                            dominant-baseline="auto" font-size="11px"
                                                            font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1076">120</tspan>
                                                            <title>120</title>
                                                        </text><text id="SvgjsText1078"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="146.3535951171875" text-anchor="end"
                                                            dominant-baseline="auto" font-size="11px"
                                                            font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1079">90</tspan>
                                                            <title>90</title>
                                                        </text><text id="SvgjsText1081"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="193.26373007812498" text-anchor="end"
                                                            dominant-baseline="auto" font-size="11px"
                                                            font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1082">60</tspan>
                                                            <title>60</title>
                                                        </text><text id="SvgjsText1084"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="240.1738650390625" text-anchor="end"
                                                            dominant-baseline="auto" font-size="11px"
                                                            font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1085">30</tspan>
                                                            <title>30</title>
                                                        </text><text id="SvgjsText1087"
                                                            font-family="Helvetica, Arial, sans-serif" x="20"
                                                            y="287.084" text-anchor="end" dominant-baseline="auto"
                                                            font-size="11px" font-weight="600" fill="#8c9097"
                                                            class="apexcharts-text apexcharts-yaxis-label apexcharts-yaxis-label"
                                                            style="font-family: Helvetica, Arial, sans-serif;">
                                                            <tspan id="SvgjsTspan1088">0</tspan>
                                                            <title>0</title>
                                                        </text></g>
                                                </g>
                                                <g id="SvgjsG1003" class="apexcharts-inner apexcharts-graphical"
                                                    transform="translate(46.96665954589844, 51.0333251953125)">
                                                    <defs id="SvgjsDefs1002">
                                                        <clipPath id="gridRectMaskwvnj37m5">
                                                            <rect id="SvgjsRect1009" width="499.03334045410156"
                                                                height="237.5506748046875" x="-3.5" y="-1.5"
                                                                rx="0" ry="0" opacity="1"
                                                                stroke-width="0" stroke="none" stroke-dasharray="0"
                                                                fill="#fff"></rect>
                                                        </clipPath>
                                                        <clipPath id="forecastMaskwvnj37m5"></clipPath>
                                                        <clipPath id="nonForecastMaskwvnj37m5"></clipPath>
                                                        <clipPath id="gridRectMarkerMaskwvnj37m5">
                                                            <rect id="SvgjsRect1010" width="496.03334045410156"
                                                                height="238.5506748046875" x="-2" y="-2"
                                                                rx="0" ry="0" opacity="1"
                                                                stroke-width="0" stroke="none" stroke-dasharray="0"
                                                                fill="#fff"></rect>
                                                        </clipPath>
                                                    </defs>
                                                    <line id="SvgjsLine1008" x1="0" y1="0"
                                                        x2="0" y2="234.5506748046875" stroke="#b6b6b6"
                                                        stroke-dasharray="3" stroke-linecap="butt"
                                                        class="apexcharts-xcrosshairs" x="0" y="0" width="1"
                                                        height="234.5506748046875" fill="#b1b9c4" filter="none"
                                                        fill-opacity="0.9" stroke-width="1"></line>
                                                    <line id="SvgjsLine1020" x1="0" y1="235.5506748046875"
                                                        x2="0" y2="241.5506748046875" stroke="#e0e0e0"
                                                        stroke-dasharray="0" stroke-linecap="butt"
                                                        class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1021" x1="61.504167556762695"
                                                        y1="235.5506748046875" x2="61.504167556762695"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1022" x1="123.00833511352539"
                                                        y1="235.5506748046875" x2="123.00833511352539"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1023" x1="184.5125026702881"
                                                        y1="235.5506748046875" x2="184.5125026702881"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1024" x1="246.01667022705078"
                                                        y1="235.5506748046875" x2="246.01667022705078"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1025" x1="307.5208377838135"
                                                        y1="235.5506748046875" x2="307.5208377838135"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1026" x1="369.0250053405762"
                                                        y1="235.5506748046875" x2="369.0250053405762"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1027" x1="430.52917289733887"
                                                        y1="235.5506748046875" x2="430.52917289733887"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <line id="SvgjsLine1028" x1="492.03334045410156"
                                                        y1="235.5506748046875" x2="492.03334045410156"
                                                        y2="241.5506748046875" stroke="#e0e0e0" stroke-dasharray="0"
                                                        stroke-linecap="butt" class="apexcharts-xaxis-tick"></line>
                                                    <g id="SvgjsG1016" class="apexcharts-grid">
                                                        <g id="SvgjsG1017" class="apexcharts-gridlines-horizontal">
                                                            <line id="SvgjsLine1030" x1="0"
                                                                y1="46.9101349609375" x2="492.03334045410156"
                                                                y2="46.9101349609375" stroke="#f2f5f7"
                                                                stroke-dasharray="0" stroke-linecap="butt"
                                                                class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1031" x1="0"
                                                                y1="93.820269921875" x2="492.03334045410156"
                                                                y2="93.820269921875" stroke="#f2f5f7"
                                                                stroke-dasharray="0" stroke-linecap="butt"
                                                                class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1032" x1="0"
                                                                y1="140.73040488281248" x2="492.03334045410156"
                                                                y2="140.73040488281248" stroke="#f2f5f7"
                                                                stroke-dasharray="0" stroke-linecap="butt"
                                                                class="apexcharts-gridline"></line>
                                                            <line id="SvgjsLine1033" x1="0"
                                                                y1="187.64053984375" x2="492.03334045410156"
                                                                y2="187.64053984375" stroke="#f2f5f7"
                                                                stroke-dasharray="0" stroke-linecap="butt"
                                                                class="apexcharts-gridline"></line>
                                                        </g>
                                                        <g id="SvgjsG1018" class="apexcharts-gridlines-vertical"></g>
                                                        <line id="SvgjsLine1036" x1="0"
                                                            y1="234.5506748046875" x2="492.03334045410156"
                                                            y2="234.5506748046875" stroke="transparent"
                                                            stroke-dasharray="0" stroke-linecap="butt"></line>
                                                        <line id="SvgjsLine1035" x1="0" y1="1"
                                                            x2="0" y2="234.5506748046875"
                                                            stroke="transparent" stroke-dasharray="0"
                                                            stroke-linecap="butt"></line>
                                                    </g>
                                                    <g id="SvgjsG1019" class="apexcharts-grid-borders">
                                                        <line id="SvgjsLine1029" x1="0" y1="0"
                                                            x2="492.03334045410156" y2="0" stroke="#f2f5f7"
                                                            stroke-dasharray="0" stroke-linecap="butt"
                                                            class="apexcharts-gridline">
                                                        </line>
                                                        <line id="SvgjsLine1034" x1="0"
                                                            y1="234.5506748046875" x2="492.03334045410156"
                                                            y2="234.5506748046875" stroke="#f2f5f7"
                                                            stroke-dasharray="0" stroke-linecap="butt"
                                                            class="apexcharts-gridline"></line>
                                                        <line id="SvgjsLine1068" x1="0"
                                                            y1="235.5506748046875" x2="492.03334045410156"
                                                            y2="235.5506748046875" stroke="#e0e0e0"
                                                            stroke-dasharray="0" stroke-width="1"
                                                            stroke-linecap="butt"></line>
                                                    </g>
                                                    <g id="SvgjsG1011"
                                                        class="apexcharts-line-series apexcharts-plot-series">
                                                        <g id="SvgjsG1012" class="apexcharts-series"
                                                            seriesName="Desktops" data:longestSeries="true"
                                                            rel="1" data:realIndex="0">
                                                            <path id="SvgjsPath1015"
                                                                d="M0 218.91396315104166L61.504167556762695 170.4401570247396L123.00833511352539 179.82218401692708L184.5125026702881 154.80344537109374L246.01667022705078 157.9307877018229L307.5208377838135 137.60306255208332L369.0250053405762 126.65736439453124L430.52917289733887 92.25659875651041L492.03334045410156 3.1273423307291637C492.03334045410156 3.1273423307291637 492.03334045410156 3.1273423307291637 492.03334045410156 3.1273423307291637 "
                                                                fill="none" fill-opacity="1"
                                                                stroke="rgba(1,98,232,0.85)" stroke-opacity="1"
                                                                stroke-linecap="butt" stroke-width="3"
                                                                stroke-dasharray="0" class="apexcharts-line"
                                                                index="0"
                                                                clip-path="url(#gridRectMaskwvnj37m5)"
                                                                pathTo="M 0 218.91396315104166 L 61.504167556762695 170.4401570247396 L 123.00833511352539 179.82218401692708 L 184.5125026702881 154.80344537109374 L 246.01667022705078 157.9307877018229 L 307.5208377838135 137.60306255208332 L 369.0250053405762 126.65736439453124 L 430.52917289733887 92.25659875651041 L 492.03334045410156 3.1273423307291637"
                                                                pathFrom="M -1 234.5506748046875 L -1 234.5506748046875 L 61.504167556762695 234.5506748046875 L 123.00833511352539 234.5506748046875 L 184.5125026702881 234.5506748046875 L 246.01667022705078 234.5506748046875 L 307.5208377838135 234.5506748046875 L 369.0250053405762 234.5506748046875 L 430.52917289733887 234.5506748046875 L 492.03334045410156 234.5506748046875"
                                                                fill-rule="evenodd"></path>
                                                            <g id="SvgjsG1013"
                                                                class="apexcharts-series-markers-wrap apexcharts-hidden-element-shown"
                                                                data:realIndex="0">
                                                                <g class="apexcharts-series-markers">
                                                                    <circle id="SvgjsCircle1092" r="0"
                                                                        cx="0" cy="0"
                                                                        class="apexcharts-marker wzd361xpz no-pointer-events"
                                                                        stroke="#ffffff" fill="#0162e8"
                                                                        fill-opacity="1" stroke-width="2"
                                                                        stroke-opacity="0.9"
                                                                        default-marker-size="0"></circle>
                                                                </g>
                                                            </g>
                                                        </g>
                                                        <g id="SvgjsG1014" class="apexcharts-datalabels"
                                                            data:realIndex="0"></g>
                                                    </g>
                                                    <line id="SvgjsLine1037" x1="0" y1="0"
                                                        x2="492.03334045410156" y2="0" stroke="#b6b6b6"
                                                        stroke-dasharray="0" stroke-width="1"
                                                        stroke-linecap="butt" class="apexcharts-ycrosshairs"></line>
                                                    <line id="SvgjsLine1038" x1="0" y1="0"
                                                        x2="492.03334045410156" y2="0"
                                                        stroke-dasharray="0" stroke-width="0"
                                                        stroke-linecap="butt" class="apexcharts-ycrosshairs-hidden">
                                                    </line>
                                                    <g id="SvgjsG1039" class="apexcharts-xaxis"
                                                        transform="translate(0, 0)">
                                                        <g id="SvgjsG1040" class="apexcharts-xaxis-texts-g"
                                                            transform="translate(0, -4)"><text id="SvgjsText1042"
                                                                font-family="Helvetica, Arial, sans-serif" x="0"
                                                                y="263.5506748046875" text-anchor="middle"
                                                                dominant-baseline="auto" font-size="11px"
                                                                font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1043">Jan</tspan>
                                                                <title>Jan</title>
                                                            </text><text id="SvgjsText1045"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="61.504167556762695" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1046">Feb</tspan>
                                                                <title>Feb</title>
                                                            </text><text id="SvgjsText1048"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="123.00833511352539" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1049">Mar</tspan>
                                                                <title>Mar</title>
                                                            </text><text id="SvgjsText1051"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="184.5125026702881" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1052">Apr</tspan>
                                                                <title>Apr</title>
                                                            </text><text id="SvgjsText1054"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="246.01667022705078" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1055">May</tspan>
                                                                <title>May</title>
                                                            </text><text id="SvgjsText1057"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="307.5208377838135" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1058">Jun</tspan>
                                                                <title>Jun</title>
                                                            </text><text id="SvgjsText1060"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="369.0250053405762" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1061">Jul</tspan>
                                                                <title>Jul</title>
                                                            </text><text id="SvgjsText1063"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="430.52917289733887" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1064">Aug</tspan>
                                                                <title>Aug</title>
                                                            </text><text id="SvgjsText1066"
                                                                font-family="Helvetica, Arial, sans-serif"
                                                                x="492.03334045410156" y="263.5506748046875"
                                                                text-anchor="middle" dominant-baseline="auto"
                                                                font-size="11px" font-weight="600" fill="#8c9097"
                                                                class="apexcharts-text apexcharts-xaxis-label apexcharts-xaxis-label"
                                                                style="font-family: Helvetica, Arial, sans-serif;">
                                                                <tspan id="SvgjsTspan1067">Sep</tspan>
                                                                <title>Sep</title>
                                                            </text></g>
                                                    </g>
                                                    <g id="SvgjsG1089"
                                                        class="apexcharts-yaxis-annotations apexcharts-hidden-element-shown">
                                                    </g>
                                                    <g id="SvgjsG1090"
                                                        class="apexcharts-xaxis-annotations apexcharts-hidden-element-shown">
                                                    </g>
                                                    <g id="SvgjsG1091"
                                                        class="apexcharts-point-annotations apexcharts-hidden-element-shown">
                                                    </g>
                                                </g>
                                            </svg>
                                            <div class="apexcharts-tooltip apexcharts-theme-light">
                                                <div class="apexcharts-tooltip-title"
                                                    style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                </div>
                                                <div class="apexcharts-tooltip-series-group" style="order: 1;"><span
                                                        class="apexcharts-tooltip-marker"
                                                        style="background-color: rgb(1, 98, 232);"></span>
                                                    <div class="apexcharts-tooltip-text"
                                                        style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                        <div class="apexcharts-tooltip-y-group"><span
                                                                class="apexcharts-tooltip-text-y-label"></span><span
                                                                class="apexcharts-tooltip-text-y-value"></span></div>
                                                        <div class="apexcharts-tooltip-goals-group"><span
                                                                class="apexcharts-tooltip-text-goals-label"></span><span
                                                                class="apexcharts-tooltip-text-goals-value"></span>
                                                        </div>
                                                        <div class="apexcharts-tooltip-z-group"><span
                                                                class="apexcharts-tooltip-text-z-label"></span><span
                                                                class="apexcharts-tooltip-text-z-value"></span></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="apexcharts-xaxistooltip apexcharts-xaxistooltip-bottom apexcharts-theme-light">
                                                <div class="apexcharts-xaxistooltip-text"
                                                    style="font-family: Helvetica, Arial, sans-serif; font-size: 12px;">
                                                </div>
                                            </div>
                                            <div
                                                class="apexcharts-yaxistooltip apexcharts-yaxistooltip-0 apexcharts-yaxistooltip-left apexcharts-theme-light">
                                                <div class="apexcharts-yaxistooltip-text"></div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-12 mb-30">
                    <div class="card card-statistics h-100">
                        <!-- action group -->
                        <div class="btn-group info-drop">
                            <button type="button" class="dropdown-toggle-split text-muted" data-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false"><i class="ti-more"></i></button>

                        </div>
                        <div class="card-body">
                            <h5 class="card-title">توزيع اشتباه حلات كوفيد بالسودان</h5>
                        </div>
                        <div id="sparkline2" class="scrollbar-x text-center"></div>
                    </div>
                </div>

            </div>

            {{-- <div class="calendar-main mb-30">
                <div class="row">
                    <div class="col-xl-12 mb-30">
                        <div class="card h-100">
                            <div class="btn-group info-drop">
                                <button type="button" class="dropdown-toggle-split text-muted"
                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                                        class="ti-more"></i></button>
                            </div>
                            <div class="card-body">
                                <div class="d-block d-md-flexx justify-content-between">
                                    <div class="d-block">
                                        <h5 class="card-title">Site Visits Growth </h5>
                                    </div>

                                </div>
                                <div id="morris-area" style="height: 320px;"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div> --}}





            <!--=================================
 wrapper -->

            <!--=================================
 footer -->

            @include('layouts.footer')
        </div><!-- main content wrapper end-->
    </div>
    </div>
    </div>

    <!--=================================
 footer -->

    @include('layouts.footer-scripts')

</body>

</html>
