<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Symptom;

class SymptomSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('symptoms')->delete();
        $symptoms = [
           
            ['disease_id' => '1','desc' => 'كثرة التبول: خاصة في الليل'],
            ['disease_id' => '2','desc' => 'صداع: خاصة في مؤخرة الرأس'],
            ['disease_id' => '3','desc' => 'ضيق في التنفس: الشعور بصعوبة في أخذ نفس عميق أو الشعور بالاختناق '],
            ['disease_id' => '4','desc' => 'ألم المفاصل: قد يكون الألم مستمرًا أو متقطعًا، وقد يزداد مع الحركة أو الضغط على المفصل.'],
            ['disease_id' => '5','desc' => 'حمى مفاجئة: غالبًا ما تكون درجة الحرارة مرتفعة (38 درجة مئوية أو أعلى)'],
           
            ];
    
            foreach ($symptoms as $key => $symptom) {
    
                Symptom::create($symptom);
    
            }
    }
}
