<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('patients', function(Blueprint $table) {
			
		    $table->foreign('nationalitie_id')->references('id')->on('nationalities')->onDelete('cascade');	
			$table->foreign('blood_id')->references('id')->on('bloods')->onDelete('cascade');		
			$table->foreign('gender_id')->references('id')->on('genders')->onDelete('cascade');			
		});
		Schema::table('symptoms', function(Blueprint $table) {
			$table->foreign('disease_id')->references('id')->on('diseases')->onDelete('cascade');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')->onDelete('cascade');
			$table->foreign('location_id')->references('id')->on('locations')->onDelete('cascade');
			$table->foreign('disease_id')->references('id')->on('diseases')->onDelete('cascade');
		});




	}

	public function down()
	{
		

		Schema::table('patients', function(Blueprint $table) {
			
			$table->dropForeign('patients_nationalitie_id_foreign');
			$table->dropForeign('patients_blood_id_foreign');
			$table->dropForeign('patients_gender_id_foreign');
		});
		Schema::table('symptoms', function(Blueprint $table) {
			$table->dropForeign('symptoms_disease_id_foreign');
		});
		Schema::table('records', function(Blueprint $table) {
			$table->dropForeign('records_patient_id_foreign');
			$table->dropForeign('records_location_id_foreign');
			$table->dropForeign('records_disease_id_foreign');
		});

	}
}
