<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('records', function (Blueprint $table) {
            $table->id(); 
            $table->date('diagnosis_date');
            $table->date('recovery_date')->nullable();
            $table->text('desc');
            $table->text('stauts');
            $table->unsignedBigInteger('patient_id');
            $table->unsignedBigInteger('location_id'); 
            $table->unsignedBigInteger('disease_id');  
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('records');
    }
};
