<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Record>
 */
class RecordFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'diagnosis_date' => $this->faker->date(),
            'diagnosis_date' => $this->faker->date(),
            'desc' =>$this->faker->sentence(),
            'stauts' => $this->faker->randomElement(['1', '4']),
            'patient_id'=>$this->faker->unique()->numberBetween(1, 40),
            'location_id' => $this->faker->randomElement(['1', '7']),
            'disease_id' => $this->faker->randomElement(['1', '9']),
           
        ];
    }
}
