<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Patient>
 */
class PatientFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => $this->faker->name(),
            'age' => $this->faker->numberBetween(18, 65),
            'phone' =>$this->faker->PhoneNumber,
            'address' => $this->faker->address(),
            'ssn'=>$this->faker->numberBetween($min = 10000000, $max = 100000000),
            'nationalitie_id' => $this->faker->randomElement(['1', '9']),
            'blood_id' => $this->faker->numberBetween($min = 1, $max = 8),
            'gender_id' => $this->faker->randomElement(['1', '2']),

           
        ];
    }
}
