<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use App\Models\Patient;
use App\Models\Location;
use App\Models\Disease;

class Record extends Model
{
    use HasFactory,SoftDeletes;
    
    protected $guarded = [];

    public function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
    public function location()
    {
        return $this->belongsTo(Location::class);
    }
    public function disease()
    {
        return $this->belongsTo(Disease::class);
    }

}
