<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;
use App\Models\Gender;
use App\Models\Nationalitie;
use App\Models\Blood;
use App\Models\Record;

class Patient extends Model
{
    use HasFactory,SoftDeletes;
    protected $guarded = [];


    public function getCreatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }

    public function getUpdatedAtAttribute($date)
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $date)->format('Y-m-d');
    }
    public function blood()
    {
        return $this->belongsTo(Blood::class);
    }
    public function nationalitie()
    {
        return $this->belongsTo(Nationalitie::class);
    }
    public function gender()
    {
        return $this->belongsTo(Gender::class);
    }

    public function records()
    {
        return $this->hasMany(Record::class); 
    }

}
