<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Translatable\HasTranslations;
use App\Models\Patient;

class Nationalitie extends Model
{
    use HasFactory;
    use HasTranslations;
    use SoftDeletes;

   
    protected $dates = ['deleted_at'];
    protected $guarded = [];
    
    public $translatable = ['name'];
    public $timestamps = true;

    public function patients()
    {
        return $this->hasMany(Patient::class); 
    }


}
