<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Patient;

class Blood extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable=['name'];

    public function users()
    {
        return $this->hasMany(User::class); 
    }

    public function patients()
    {
        return $this->hasMany(Patient::class); 
    }

}
