<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreRecordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'desc' => 'required',
            'stauts' => 'required',
            'patient_id' => 'required',
            'location_id' => 'required',
            'disease_id' => 'required',
            'diagnosis_date' => 'required',
        ];
    }
    public function messages()
    {
        return [
            'desc.required' =>  'يرجى ادخال وصف  ',
            'stauts.required' =>  'يرجى ادخال حالة المريض ',
            'patient_id.required' =>  'يرجى ادخال رقم المريض ',
            'location_id.required' =>  'يرجى ادخال الموقع  ',
            'disease_id.required' =>  'يرجى ادخال الوباء  ',
            'diagnosis_date.required' =>  'يرجى ادخال تاريخ التشخيص  ',
           
        ];
    }
}
