<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePatientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'age' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'ssn' => 'required',
            'nationalitie_id' => 'required',
            'blood_id' => 'required',
            'gender_id' => 'required',

        ];
    }
    public function messages()
    {
        return [
            'name.required' =>  'يرجى ادخال اسم المريض ',
            'age.required' =>  'يرجى ادخال عمر المريض ',
            'phone.required' =>  'يرجى ادخال رقم الهاتف ',
            'address.required' =>  'يرجى ادخال العنوان  ',
            'ssn.required' =>  'يرجى ادخال الرقم الوطني ',
            'nationalitie_id.required' =>  'يرجى ادخال الجنسية  ',
            'blood_id.required' =>  'يرجى ادخال فصيلة الدم ',
            'gender_id.required' =>  'يرجى ادخال نوع المريض ',
           
        ];
    }
}
