<?php

namespace App\Http\Livewire;

use App\Models\Grade;
use App\Models\Certificate;
use App\Models\Dept;
use App\Models\Nationalitie;
use App\Models\Religion;
use App\Models\Blood;
use App\Models\User;
use App\Models\Gender;
use App\Models\Image;
use Illuminate\Support\Facades\Hash;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;


class AddStudent extends Component
{
    use WithFileUploads;


    public $catchError,$updateMode = false,$show_table = true,$user_id;
    public $successMessage = '';
    public $photos = [];
    public $currentStep = 1,

    // Student_INPUTS
   
    $name,$name_en, $email,
    $password, $phone,
    $dept_id, $nationalitie_id,
    $blood_id, $religion_id, $ssn,
    $birth_date, $gender_id,
    $address,
    
    // Father_INPUTS
    $f_name_ar, $second_name_ar,
    $midell_name_ar, $last_name_ar,
    $f_name_en, $second_name_en,
    $midell_name_en, $last_name_en, $f_phone,
    $f_ssn;

    public function updated($propertyName)
    {
        
        $this->validateOnly($propertyName, [
            'email' => 'required|email',
            'phone' => 'min:10|regex:/^([0-9\s\-\+\(\)]*)$/',
            'ssn' => 'required|string|min:10|max:10|regex:/[0-9]{9}/',
        ]);
        
    }
    
          
    public function render()
    {

        return view('livewire.add-student', [
            'Nationalities' => Nationalitie::all(),
            'Bloods' => Blood::all(),
            'Religions' => Religion::all(),
            'depts' => Dept::all(),
            'genders' => Gender::all(),
            'users' => User::where('user_type','stu')->get(),
        ]);

    } 

    public function firstStepSubmit()
    {
         
        $this->validate([
            'email' => 'required|unique:users,email,'.$this->id,
            'password' => 'required',
            'name' => 'required',
            'name_en' => 'required',
            'dept_id' => 'required', 
            'religion_id' => 'required',
            'blood_id' => 'required',
            'nationalitie_id' => 'required',
            'ssn' => 'required|unique:users,ssn,' . $this->id,
            'phone' => 'min:10|required|regex:/^([0-9\s\-\+\(\)]*)$/',
            'gender_id' => 'required' ,
            'birth_date' => 'required',
            'address' => 'required',
        ]);
        
        $this->currentStep = 2;
    }//end of firstStepSubmit
    public function secondStepSubmit()
    {
       
        $this->validate([
            'f_name_ar' => 'required',
            'second_name_ar' => 'required',
            'midell_name_ar' => 'required',
            'last_name_ar' => 'required',

            'f_name_en' => 'required',
            'second_name_en' => 'required',
            'midell_name_en' => 'required',
            'last_name_en' => 'required',

            'f_phone' => 'min:10|required|regex:/^([0-9\s\-\+\(\)]*)$/',
            'f_ssn' => 'required|unique:users,ssn,' . $this->id,      

        ]);
        
        $this->currentStep = 3;
    }//end of secondStepSubmit

    public function submitForm(){

        DB::beginTransaction();

        try {
            $user = new User;
            // Student_INPUTS 13
            $user->email = $this->email;
            $user->password = Hash::make($this->password);
            $user->name = ['en' => $this->name_en, 'ar' => $this->name];
            $user->dept_id = $this->dept_id;
            $user->religion_id = $this->religion_id;
            $user->blood_id = $this->blood_id;
            $user->nationalitie_id = $this->nationalitie_id;
            $user->ssn = $this->ssn;
            $user->phone = $this->phone;
            $user->gender_id = $this->gender_id;
            $user->birth_date = $this->birth_date;
            $user->address = $this->address;

            // Fother_INPUTS 11
             $user->f_name = ['en' => $this->f_name_en, 'ar' => $this->f_name_ar];
             $user->second_name = ['en' => $this->second_name_en, 'ar' => $this->second_name_ar];
             $user->midell_name = ['en' => $this->midell_name_en, 'ar' => $this->midell_name_ar];
             $user->last_name = ['en' => $this->last_name_en, 'ar' => $this->last_name_ar];
             $user->f_phone = $this->f_phone;
             $user->f_ssn = $this->f_ssn;
            
            $user->save();

            if (!empty($this->photos)){

                foreach($this->photos as $file)
                {
                    $name = $file->getClientOriginalName();
                    $file->storeAs('attachments/students/'.$user->id, $file->getClientOriginalName(),'upload_attachments');

                    // insert in image_table
                    $images= new Image();
                    $images->filename=$name;
                    $images->imageable_id= $user->id;
                    $images->imageable_type = 'App\Models\User';
                    $images->save();
                }
            }

            DB::commit(); // insert data
            $this->successMessage = trans('messages.success');
            $this->clearForm();
            $this->currentStep = 1;
        }

        catch (\Exception $e) {
            DB::rollback();
            $this->catchError = $e->getMessage();
        };



    }//end of submitForm

    public function edit($id)
    {
        $this->show_table = false;
        $this->updateMode = true;
        $user = User::where('id',$id)->first();
        $this->user_id = $id;
        $this->email = $user->email;
        $this->Password = $user->Password;
        $this->name = $user->getTranslation('name', 'ar');
        $this->name_en = $user->getTranslation('name', 'en');
        $this->phone =$user->phone;
        $this->dept_id = $user->dept_id;
        $this->nationalitie_id = $user->nationalitie_id;
        $this->blood_id = $user->blood_id;
        $this->religion_id = $user->religion_id;
        $this->ssn =$user->ssn;
        $this->birth_date =$user->birth_date;
        $this->gender_id =$user->gender_id;
        $this->address =$user->address;

        $this->f_name_ar = $user->getTranslation('f_name', 'ar');
        $this->f_name_en = $user->getTranslation('f_name', 'en');
        $this->second_name_ar = $user->getTranslation('second_name', 'ar');
        $this->second_name_en = $user->getTranslation('second_name', 'en');
        $this->midell_name_ar = $user->getTranslation('midell_name', 'ar');
        $this->midell_name_en = $user->getTranslation('midell_name', 'en');
        $this->last_name_ar = $user->getTranslation('last_name', 'ar');
        $this->last_name_en = $user->getTranslation('last_name', 'en');
        $this->f_phone =$user->f_phone;
        $this->f_ssn = $user->f_ssn;
       
    }//end of edit

   
    public function show($id)
    {
       
       $user = User::findOrFail($id)->dd();
       
        return view('livewire.show-user',compact('user'));
    } // End of delete

   
     
     public function firstStepSubmit_edit()
     {
         $this->updateMode = true;
         $this->currentStep = 2;
 
     }// end firstStepSubmit_edit

     public function secondStepSubmit_edit()
     {
         $this->updateMode = true;
         $this->currentStep = 3;
 
     }//end of secondStepSubmit_edit

     public function submitForm_edit(){

        if ($this->user_id){
            $parent = User::find($this->user_id);
            $parent->update([
            'email' => $this->email,
            'name' =>   ['en' => $this->name_en, 'ar' => $this->name],
            'dept_id' => $this->dept_id,
            'religion_id' => $this->religion_id,
            'blood_id' => $this->blood_id,
            'nationalitie_id' => $this->nationalitie_id,
            'ssn' => $this->ssn,
            'phone' => $this->phone,
            'gender_id' => $this->gender_id,
            'birth_date' => $this->birth_date,
            'address' => $this->address,
            // Fother_INPUTS 11
            'f_name' => ['en' => $this->f_name_en, 'ar' => $this->f_name_ar],
            'second_name' => ['en' => $this->second_name_en, 'ar' => $this->second_name_ar],
            'midell_name' => ['en' => $this->midell_name_en, 'ar' => $this->midell_name_ar],
            'last_name' => ['en' => $this->last_name_en, 'ar' => $this->last_name_ar],
            'f_phone' => $this->f_phone,
            'f_ssn' => $this->f_ssn,
            

            ]);

        }
        $this->successMessage = trans('messages.success');
        return redirect()->to('/add_student');
    }


    public function delete($id){
        User::findOrFail($id)->delete();
        return redirect()->to('/add_student');
    } // End of delete
 

    //back
    public function back($step)
    {
        $this->currentStep = $step;
    }

    public function clearForm()
    {
        //Student of class
        $this->email = '';
        $this->password = '';
        $this->name = '';
        $this->name_en = '';
        $this->dept_id = '';
        $this->religion_id = '';
        $this->blood_id ='';
        $this->nationalitie_id = '';
        $this->ssn = '';
        $this->phone = '';
        $this->gender_id = '';
        $this->birth_date ='';
        $this->address ='';
        //Father input
        $this->f_name_ar ='';
        $this->second_name_ar = '';
        $this->midell_name_ar = '';
        $this->last_name_ar = '';
        $this->f_name_en = '';
        $this->second_name_en ='';
        $this->midell_name_en ='';
        $this->last_name_en = '';
        $this->f_phone = '';
        $this->f_ssn ='';
        
    }

    public function showformadd(){
        $this->show_table = false;
    }





}//end of class
