<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Requests\UserStoreRequest;
use App\Models\User;
use App\Models\Nationalitie;
use App\Models\Blood;
use App\Models\Religion;
use App\Models\Dept;
use App\Models\Gender;
use App\Models\Image;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Hash;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Exports\UsersExport;
use App\Imports\UsersImport;
use Maatwebsite\Excel\Facades\Excel;


class UserController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:عرض مستخدم', ['only' => ['index']]);
    $this->middleware('permission:اضافة مستخدم', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل مستخدم', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف مستخدم', ['only' => ['destroy']]);

    }
    public function index()
    {
        $users =  User::where('user_type','admin')
        ->OrWhere('user_type','emp')->get();
        
        return view('pages.users.index',compact('users'));
    }

    
    public function create()
    {
        $roles = Role::pluck('name','name')->all();
        
        $depts = Dept::all();
        $genders = Gender::all();
        return view('pages.users.create',compact('roles','depts','genders'));
    }

    public function store(UserStoreRequest $request)
    {
        
       try  
       {
       
        $user = new User; 
        $user->first_name = $request->first_name;
        $user->email = $request->email;
        $user->password =  Hash::make($request['password']);
        $user->user_type = $request->user_type;
        $user->roles_name = $request->roles_name;
        $user->gender_id = $request->gender_id; 
        $user->dept_id = $request->dept_id; 
        $user->phone = $request->phone; 
        $user->email_verified_at = '2023-08-05 17:57:38'; 
        $user->user_type = $request->user_type; 
        $user->save();
        
        $user->assignRole($request['roles_name']); 

        toastr()->success(trans('messages.success'));
        return redirect()->route('users.index');

       }

       catch (\Exception $e){
          DB::rollback();
           return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }

    }//End of store

   
    public function show(User $user)
    {
        //$user = User::where('id',$id)->first();
        //dd($user);
        return view('pages.users.show',compact('user'));
    }

    
    public function edit($id)
    {
        $user = User::find(decrypt($id));
         $depts = Dept::all();
         $roles = Role::pluck('name','name')->all();
         $userRole = $user->roles->pluck('name','name')->all();
        
        return view('pages.users.edit',compact('user','depts','roles','userRole'));
    }

 
    public function update(Request $request, User $user )
    {
        $id = $user->id;

        $this->validate($request, 
        [
            'first_name' => 'required',
            'email' => 'required|email|unique:users,email,'.$id,
            'phone' => 'required|min:10|regex:/^([0-9\s\-\+\(\)]*)$/',
            'dept_id' => 'required',
            'roles' => 'required',
            'user_type' => 'required',
         ],
         [
            'first_name.required' =>'يرجي ادخال الاسم ',
            'email.required' =>'يرجي ادخال البريد الالكتروني ',
            'phone.required' =>'يرجى ادخال رقم الهاتف',
            'phone.min' =>'اقل رقم هاتف من 10 خانات',
            'phone.regex' =>'صيغة رقم هاتف غير صحيحة',
            'dept_id.required' =>'يرجي ادخال القسم ',
            'roles.required' =>'يرجى اختيار الصلاحية',
            'user_type.required' =>'يرجى اختيار نوع المستخدم',
        ]
        );

        try {
            $user->first_name = $request->first_name;
            $user->dept_id = $request->dept_id;
            $user->phone = $request->phone;
            $user->email = $request->email;
            $user->last_name = $request->last_name;
            $user->user_type = $request->user_type;
            if(!empty( $request->password))
            {
            $user->password =  Hash::make($request['password']);
            }
            
            // if ($request->hasFile('ssn')) {
            //     Storage::delete($delivery->ssn);
            //     $image = $request->file('ssn');
            //     $filename = time() . '.' . $image->getClientOriginalExtension();
            //     $location = public_path('images/ssn/' . $filename);
            //     Image::make($image)->resize(500, 600)->save($location);
            //     $delivery->ssn = $filename;
            // }  
            $user->save();
            DB::table('model_has_roles')->where('model_id',$id)->delete();
            $user->assignRole($request['roles']); 
                
            toastr()->success(trans('messages.Update')); 
            return redirect()->route('users.index');
            }
            catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
            }
    }

   
    public function destroy(Request $request)
    {
        
        try {
            User::find($request->id)->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('users.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function Delete_Student($request)
    {

        User::destroy($request->id);
        toastr()->error(trans('messages.Delete'));
        return redirect()->route('users.index');
    }

    public function Upload_attachment(Request $request)
    {
        foreach($request->file('photos') as $file)
        {
            $name = $file->getClientOriginalName();
            $file->storeAs('attachments/students/'.$request->user_id, $file->getClientOriginalName(),'upload_attachments');

            // insert in image_table
            $images= new image();
            $images->filename=$name;
            $images->imageable_id = $request->user_id;
            $images->imageable_type = 'App\Models\User';
            $images->save();
        }
        toastr()->success(trans('messages.success'));
        return redirect()->route('users.show',$request->user_id);
       
    }

    public function Download_attachment($user_id, $filename)
    {
        return response()->download(public_path('attachments/students/'.$user_id.'/'.$filename));
    }

    public function Delete_attachment(Request $request)
    {
        //dd($request->all());
        // Delete img in server disk
        Storage::disk('upload_attachments')->delete('attachments/students/'.$request->user_id.'/'.$request->filename);

        // Delete in data
        image::where('id',$request->id)->where('filename',$request->filename)->delete();
        toastr()->error(trans('messages.Delete'));
        return redirect()->route('users.show',$request->user_id);
    }


    public function userLogout()
    {
         Session::flush();
         Auth::logout();
       
        return redirect('/login');
    }

    public function showChangePasswordForm(){
        return view('auth.changepassword');
      }
      
      public function changePassword(Request $request){
      
       
        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            // The passwords matches
            return redirect()->back()->withErrors(['error' => 'كلمة المرور غير صحيحة']);
        }
      
        if(strcmp($request->get('current-password'), $request->get('new-password')) == 0){
            //Current password and new password are same
            return redirect()->back()->withErrors(['error' => 'لايمكن ادخال نفس كلمة المرور القديمة']);
        }
      
        $validatedData = $request->validate([
            'current-password' => 'required',
            'new-password' => 'required|string|min:6|confirmed',
        ]);
      
        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new-password'));
        $user->save();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
      
      }

      public function export() 
    {
        return Excel::download(new UsersExport, 'users.xlsx');
    }
    // public function import() 
    // {
    //     Excel::import(new UsersImport, 'users.xlsx');
        
    //     return redirect('/')->with('success', 'All good!');
    // }

    public function studentimport() 
    {
        return view('pages.users.import');
    }
    public function studentfileupload(Request $request)
    {
        request()->validate([
            'students' => 'required|mimes:xlx,xls,xlsx|max:2048'
        ]);
        Excel::import(new UsersImport, $request->file('students'));
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
    

}//end of controller 
