<?php

namespace App\Http\Controllers;

use App\Models\Symptom;
use App\Models\Disease;
use App\Http\Requests\StoreSymptomRequest;
use App\Http\Requests\UpdateSymptomRequest;
use Illuminate\Http\Request;

class SymptomController extends Controller
{
   
    public function index()
    {
        $symptoms = Symptom::all();
        $diseases = Disease::all();
        return view('pages.Symptoms.index',compact('symptoms','diseases'));
    }

   
    public function store(StoreSymptomRequest $request)
    {
        try {

            $validated = $request->validated();

            $symptom = new Symptom; 
            $symptom->desc = $request->desc;
            $symptom->disease_id = $request->disease_id;
            $symptom->save();

            toastr()->success(trans('messages.success'));
            return redirect()->route('symptoms.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function update(UpdateSymptomRequest $request, Symptom $symptom)
    {
        try {

            $validated = $request->validated();
            $symptom = Symptom::findOrFail($request->id);
           
            $symptom->desc = $request->desc;
            $symptom->disease_id = $request->disease_id;
            $symptom->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('symptoms.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function destroy(Request $request)
    {
        try {
            
            $symptom = Symptom::where('id',$request->id)->first();
            $symptom->delete();
            toastr()->error(trans('messages.Delete'));
           return redirect()->route('symptoms.index');
       }

       catch (\Exception $e){
       return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }
    }
}
