<?php

namespace App\Http\Controllers;

use App\Models\Record;
use App\Http\Requests\StoreRecordRequest;
use App\Http\Requests\UpdateRecordRequest;
use App\Models\Disease;
use App\Models\Location;
use App\Models\Patient;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Exports\RecordsExport;
use Maatwebsite\Excel\Facades\Excel;


class RecordController extends Controller
{
    

    public function index()
    {
        $patients = Patient::all();
        $locations = Location::all();
        $diseases = Disease::all();
        $records = Record::all();
        return view('pages.Records.index',compact('patients','locations','diseases','records'));
    }

    public function store(StoreRecordRequest $request)
    {
        //dd($request->all());
        $originalDateString = $request->diagnosis_date;
        $carbonDate = Carbon::createFromFormat('d/m/Y', $originalDateString);
        $laravelFormattedDate = $carbonDate->format('Y-m-d');
        $diagnosisDdate = $laravelFormattedDate;


        try {

            $validated = $request->validated();

            $record = new Record; 
            $record->diagnosis_date = $diagnosisDdate;
            $record->recovery_date = $request->recovery_date;
            $record->desc = $request->desc;
            $record->stauts = $request->stauts;
            $record->patient_id = $request->patient_id;
            $record->location_id = $request->location_id;
            $record->disease_id = $request->disease_id;
            $record->save();

            toastr()->success(trans('messages.success'));
            return redirect()->route('records.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

  
    public function show(Record $record)
    {
        //
    }

    public function update(UpdateRecordRequest $request, Record $Record)
    {
        
         
        try {

            $validated = $request->validated();
            $record = Record::findOrFail($request->id);
           
            $record->desc = $request->desc;
            $record->stauts = $request->stauts;
            $record->patient_id = $request->patient_id;
            $record->location_id = $request->location_id;
            $record->disease_id = $request->disease_id;
            $record->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('records.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function destroy(Request $request)
    {
        try {
            
            $record = Record::where('id',$request->id)->first();
            $record->delete();
            toastr()->error(trans('messages.Delete'));
           return redirect()->route('records.index');
       }

       catch (\Exception $e){
       return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }
    }

    public function exportRecords() 
    {
        return Excel::download(new RecordsExport, 'Records.xlsx');
    }
    
}
