<?php

namespace App\Http\Controllers;

use App\Models\Patient;
use App\Http\Requests\StorePatientRequest;
use App\Http\Requests\UpdatePatientRequest;
use App\Models\Gender;
use App\Models\Blood;
use App\Models\Nationalitie;
use Illuminate\Http\Request;
use App\Exports\PatientsExport;
use Maatwebsite\Excel\Facades\Excel;

class PatientController extends Controller
{
   
   

    public function index()
    {
        $patients = Patient::all();
        $genders = Gender::all();
        $bloods = Blood::all();
        $nationalities = Nationalitie::all();
        return view('pages.Patients.index',compact('patients','genders','bloods','nationalities'));
    }

   
    public function store(StorePatientRequest $request)
    {
       
        try {

            $validated = $request->validated();

            $patient = new Patient; 
            $patient->name = $request->name;
            $patient->age = $request->age;
            $patient->phone = $request->phone;
            $patient->address = $request->address;
            $patient->ssn = $request->ssn;
            $patient->nationalitie_id = $request->nationalitie_id;
            $patient->blood_id = $request->blood_id;
            $patient->gender_id = $request->gender_id;
            $patient->save();

            toastr()->success(trans('messages.success'));
            return redirect()->route('patients.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function show(Patient $patient)
    {
        //
    }

    public function update(UpdatePatientRequest $request, Patient $patient)
    {
        try {

            $validated = $request->validated();
            $patient = Patient::findOrFail($request->id);
           
            $patient->name = $request->name;
            $patient->age = $request->age;
            $patient->phone = $request->phone;
            $patient->address = $request->address;
            $patient->ssn = $request->ssn;
            $patient->nationalitie_id = $request->nationalitie_id;
            $patient->blood_id = $request->blood_id;
            $patient->gender_id = $request->gender_id;
            $patient->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('patients.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function destroy(Request $request)
    {
        try {
            
            $patient = Patient::where('id',$request->id)->first();
            $patient->delete();
            toastr()->error(trans('messages.Delete'));
           return redirect()->route('patients.index');
       }

       catch (\Exception $e){
       return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }
    }

    public function exportPatients() 
    {
        return Excel::download(new PatientsExport, 'Patients.xlsx');
    }


}
