<?php

namespace App\Http\Controllers;

use App\Models\Location;
use App\Http\Requests\StoreLocationRequest;
use App\Http\Requests\UpdateLocationRequest;
use Illuminate\Http\Request;

class LocationController extends Controller
{
   
    public function index()
    {
        $locations = Location::all();
        return view('pages.Locations.index',compact('locations'));
    }

    public function store(StoreLocationRequest $request)
    {
        try {

            $validated = $request->validated();

            $location = new Location; 
            $location->name = $request->name;
            $location->save();

            toastr()->success(trans('messages.success'));
            return redirect()->route('locations.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function update(UpdateLocationRequest $request, Location $location)
    {
        try {

            $validated = $request->validated();
            $location = Location::findOrFail($request->id);
           
            $location->name = $request->name;
            $location->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('locations.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

    public function destroy(Request $request)
    {
        try {
            
            $location = Location::where('id',$request->id)->first();
            $location->delete();
            toastr()->error(trans('messages.Delete'));
           return redirect()->route('locations.index');
       }

       catch (\Exception $e){
       return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }
    }
}
