<?php

namespace App\Http\Controllers;

use App\Models\Disease;
use App\Http\Requests\StoreDiseaseRequest;
use App\Http\Requests\UpdateDiseaseRequest;
use Illuminate\Http\Request;

class DiseaseController extends Controller
{
   
    public function index()
    {
        $diseases = Disease::all();
        return view('pages.Diseases.index',compact('diseases'));
    }

    public function store(StoreDiseaseRequest $request)
    {
        try {

            $validated = $request->validated();

            $disease = new Disease; 
            $disease->name = $request->name;
            $disease->save();

            toastr()->success(trans('messages.success'));
            return redirect()->route('diseases.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function show(Disease $disease)
    {
        //
    }

    
    public function edit(Disease $disease)
    {
        //
    }

   
    public function update(UpdateDiseaseRequest $request, Disease $disease)
    {
        try {

            $validated = $request->validated();
            $disease = Disease::findOrFail($request->id);
           
            $disease->name = $request->name;
            $disease->save();

            toastr()->success(trans('messages.Update'));
            return redirect()->route('diseases.index');
        }
        catch
        (\Exception $e) {
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }
    }

   
    public function destroy(Request $request)
    {
         try {
            
            $disease = Disease::where('id',$request->id)->first();
            $disease->delete();
            toastr()->error(trans('messages.Delete'));
           return redirect()->route('diseases.index');
       }

       catch (\Exception $e){
       return redirect()->back()->withErrors(['error' => $e->getMessage()]);
       }
    }
}
