<?php

namespace App\Exports;

use App\Models\Certificat;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class GraduatesExport implements FromCollection,WithHeadings,WithColumnFormatting
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Certificat::select(
            'user_id','amount','notification_number','certificat_number',
            'f_status','f_note'
        )
        ->whereNotNull('specialty_id')
        ->get();
    }

    public function columnFormats(): array
    {
        return [
            'B' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
        ];
    }

    public function headings(): array
    {
        return [
            'الرقم','المبلغ','رقم الاشعار','عدد الشهادات',
            'الحالة المالية','تعليق المالية'
        
        ];
    }

}
