<?php

namespace App\Exports;

use App\Models\Certificat;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class CertificatsExport implements FromCollection,WithHeadings,WithColumnFormatting
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
       return Certificat::select( 
        'user_id','amount','notification_number','certificat_number',
        'f_note','f_status','created_at'
        )
        ->whereNull('specialty_id')
        ->where('f_status','1') 
        ->Where('r_status','1') 
        ->get();
    }
 public function columnFormats(): array
    {
        return [
            
            'B' => NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1,
           
        ];
    }
    public function headings(): array
    {
        return [
           'الرقم','المبلغ','رقم الاشعار','عدد الشهادات','تعليق المالية','الحالة','التاريخ'
           
        
        ];
    }
    
   
    
}
