@extends('layouts.master')
@section('css')

@section('title')
    Add Role
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Add Role </h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.user') }}</a></li>
                <li class="breadcrumb-item active">Add Role</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
<a href="{{ route('users.index') }}">
    <button type="button" class="button x-small">
        Back
    </button>
</a><br><br>
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                {!! Form::open(['route' => 'roles.store', 'method' => 'POST']) !!}
                <!-- row -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="card mg-b-20">
                            <div class="card-body">
                                <div class="main-content-label mg-b-5">
                                    <div class="col-xs-7 col-sm-7 col-md-7">
                                        <div class="form-group">
                                            <p> Role Name :</p>
                                            {!! Form::text('name', null, ['class' => 'form-control']) !!}
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <!-- col -->
                                    <div class="col-lg-4">
                                        <ul id="treeview1">
                                            <li><a href="#">Roles</a>
                                                <ul>
                                            </li>
                                            @foreach ($permission as $value)
                                                <label
                                                    style="font-size: 16px;">{{ Form::checkbox('permission[]', $value->id, false, ['class' => 'name']) }}
                                                    {{ $value->name }}</label>
                                            @endforeach
                                            </li>

                                        </ul>
                                        </li>
                                        </ul>
                                    </div>
                                    <!-- /col -->
                                    <div class="col-xs-12 col-sm-12 col-md-12 text-center">
                                        <button type="submit" class="btn btn-main-primary">Save</button>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- row closed -->

            </div>
        </div>
    </div>
</div>
</div>
<!-- row closed -->
@endsection

@section('js')

<script>
    var date = $('.fc-datepicker').datepicker({

        'format': 'yyyy-mm-dd',
    }).val();
</script>

@endsection
