@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    Idea - Payments
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Idea - Payments</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> Idea - Payments</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                <a href="{{ route('payments.create') }}">
                    <button type="button" class="btn btn-primary l-t-20">
                        {{ trans('Certificat_trans.submit') }}
                    </button>
                    <br><br>
                </a>


                <div class="table-responsive">
                    <table id="datatable" class="table mg-b-0 text-md-nowrap">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Code Name</th>
                                <th>Item Name</th>
                                <th>Category</th>
                                <th>Quantity</th>
                                <th>Amount</th>
                                <th>Date</th>
                                <th>Opration</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($payments as $index => $payment)
                                <tr>

                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $payment->code->name }}</td>
                                    <td>{{ $payment->lab->name }}</td>
                                    <td>{{ $payment->course->name }}</td>
                                    <td>{{ $payment->qty }}</td>
                                    <td>{{ $payment->amount }}</td>
                                    <td>{{ $payment->created_at }}</td>
                                    <td>

                                        <a href="{{ route('payments.edit', encrypt($payment->id)) }}">
                                            <button type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                                title="{{ trans('Certificat_trans.Edit') }}"><i
                                                    class="fa fa-edit"></i></button>
                                        </a>

                                        <a href="{{ route('payments.show', encrypt($payment->id)) }}">
                                            <button type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                title="{{ trans('Certificat_trans.show') }}"><i
                                                    class="fa fa-eye"></i></button>
                                        </a>

                                        <button class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete"
                                            data-id="{{ $payment->id }}"
                                            title="{{ trans('Certificat_trans.Delete') }}"><i
                                                class="fa fa-trash"></i></button>

                                    </td>
                                </tr>


                                <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['payments.destroy', $payment->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id"
                                                    class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var modal = $(this)
        modal.find('.modal-body #id').val(id);

    })
</script>

@toastr_js
@toastr_render
@endsection
