@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    Idea - Items
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> Item Details</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a>
                </li>
                <li class="breadcrumb-item active"> Item Details</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->

<div class="container my-5">
    <div>
        <a href="{{ route('labs.index') }}">
            <button type="button" class="btn btn-primary l-t-20">
                {{ trans('main_trans.back') }}
            </button>
            <br><br>
        </a>
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
    </div>
    <!-- Item Details Table -->
    <div class="card mb-5">
        <div class="card-header bg-primary text-white text-center">Item Details</div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>Item Name</th>
                            <th>Unit</th>
                            <th>Budget</th>
                            <th>Cost</th>
                            <th>Balance</th>
                            <th>Executed</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>{{ $lab->desc }} </td>
                            <td>{{ $lab->unit->name }}</td>
                            <td>{{ $lab->budget }}</td>
                            <td>{{ $lab->cost }}</td>
                            <td>{{ $lab->balance }}</td>
                            <td>{{ $lab->execute }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Item Codes Table -->
    <div class="card">
        <div class="card-header bg-success text-white text-center">Item Codes</div>
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Code Name</th>
                            <th>Executed</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($codes as $index => $code)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $code->name }} </td>
                                <td>{{ $code->execute }}</td>

                            </tr>
                        @endforeach

                    </tbody>
                </table>
            </div>
        </div>
    </div>

</div>
</div><br><br><br>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
