@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
    {{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Certificat_trans.title_page') }}
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#"
                        class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <a href="{{ route('certificats.index') }}">
            <button type="button" class="btn btn-primary l-t-20">
                {{ trans('main_trans.back') }}
            </button>
        </a>
        <br><br>
        <div class="card card-statistics h-100">

            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                {{-- <form method="post"  action="{{ route('certificats.store') }}" autocomplete="off" files="ture"> --}}
                {!! Form::open(['route' => 'certificats.store', 'autocomplete' => 'off', 'files' => 'ture']) !!}
                @csrf

                <div class="row">
                    <div class="col-12 sm-mb-30">
                        <span class="text-success">{{ trans('main_trans.info') }}</span>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 sm-mb-30">
                        <span class="text-danger">{{ trans('Certificat_trans.text8') }}</span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 sm-mb-30">
                        <span class="text-danger">{{ trans('Certificat_trans.text9') }}</span>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12 sm-mb-30">
                        <span class="text-danger">{{ trans('Certificat_trans.text10') }}</span>
                    </div>
                </div><br>

                <div class="row">
                    <div class="col-lg-3">
                        <label>{{ trans('Certificat_trans.certificat_type') }} : <span class="text-danger">* يمكن
                                اختيار النوعين</span></label>
                    </div>
                    <div class="col-lg-3">
                        <fieldset>
                            <div>
                                <input type="checkbox" id="coding" name="certificat_type[]" value='2' />
                                <label>{{ trans('Certificat_trans.Regular') }}</label>
                            </div>
                            <div>
                                <input type="checkbox" id="music" name="certificat_type[]" value='1' />
                                <label for="music">{{ trans('Certificat_trans.Details') }}</label>
                            </div>
                        </fieldset>
                    </div>
                    <div class="col-lg-6">
                        {{-- language --}}
                        <fieldset>
                            <input type="checkbox" id="lang1" name="lang[]" value='11' />
                            <label>{{ trans('Certificat_trans.Arabic') }}</label>

                            <input type="checkbox" id="lang2" name="lang[]" value='21' />
                            <label>{{ trans('Certificat_trans.English') }}</label>

                        </fieldset>
                        <fieldset>
                            <input type="checkbox" id="lang1" name="lang[]" value='11' />
                            <label>{{ trans('Certificat_trans.Arabic') }}</label>

                            <input type="checkbox" id="lang2" name="lang[]" value='21' />
                            <label>{{ trans('Certificat_trans.English') }}</label>

                        </fieldset>
                    </div>
                </div>


                <div class="row" id="ar">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.First_name') }} : <span
                                    class="text-danger">*</span></label>
                            <input class="form-control" name="first_name[]" type="text"
                                value="{{ old('first_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.Second_name') }} : <span
                                    class="text-danger">*</span></label>
                            <input class="form-control" name="second_name[]" type="text"
                                value="{{ old('second_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.Third_name') }} : <span
                                    class="text-danger">*</span></label>
                            <input class="form-control" name="midell_name[]" type="text"
                                value="{{ old('midell_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.Last_name') }} : <span
                                    class="text-danger">*</span></label>
                            <input class="form-control" name="last_name[]" type="text"
                                value="{{ old('last_name') }}">
                        </div>
                    </div>
                </div>

                <div class="row" id="en">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>First Name : <span class="text-danger">*</span></label>
                            <input class="form-control" name="first_name[]" type="text"
                                value="{{ old('first_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Second Name : <span class="text-danger">*</span></label>
                            <input class="form-control" name="second_name[]" type="text"
                                value="{{ old('second_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Third Name : <span class="text-danger">*</span></label>
                            <input class="form-control" name="midell_name[]" type="text"
                                value="{{ old('midell_name') }}">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Last Name : <span class="text-danger">*</span></label>
                            <input class="form-control" name="last_name[]" type="text"
                                value="{{ old('last_name') }}">
                        </div>
                    </div>
                </div>

                <div class="row">

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="bank">{{ trans('Certificat_trans.certificat_number') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="certificat_number" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                <option value='1'> 1</option>
                                <option value='2'> 2</option>
                                <option value='3'> 3</option>
                                <option value='4'> 4</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="bank">{{ trans('Certificat_trans.amount') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="amount" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                <option value='105.000'>105.000</option>
                                <option value='210.000'>210.000</option>
                                <option value='125.000'>125.000</option>
                                <option value='250.000'>250.000</option>
                                <option value='230.000'>230.000</option>
                                <option value='460.000'>460.000</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="notification_number">{{ trans('Certificat_trans.notification_number') }} :
                                <span class="text-danger">*</span></label>
                            <input class="form-control" name="notification_number" type="number"
                                value="{{ old('notification_number') }}">
                        </div>
                    </div>


                </div>


                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.admission_year') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="admission_year" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                @foreach ($years as $year)
                                    <option value='{{ $year->name }}'> {{ $year->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.guraduate_year') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="guraduate_year" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                @foreach ($years as $year)
                                    <option value='{{ $year->name }}'> {{ $year->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <p class="text-danger">* صيغة المرفقات: jpeg ,jpg , png </p>
                <div class="row">

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="personal_image">{{ trans('Certificat_trans.personal_image') }} : <span
                                    class="text-danger">*</span></label>
                            <input type="file" name="personal_image" class="dropify" accept="image/*"
                                data-height="70" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="bank">{{ trans('Certificat_trans.bank') }} : <span
                                    class="text-danger">*</span></label>
                            <input type="file" name="bank" class="dropify" accept="image/*"
                                data-height="70" />
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="ssn">{{ trans('Certificat_trans.ssn') }} : <span
                                    class="text-danger">*</span></label>
                            <input type="file" name="ssn" class="dropify" accept="image/*"
                                data-height="70" />
                        </div>
                    </div>

                </div><br>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="school_certificat">{{ trans('Certificat_trans.school_certificat') }} : <h6>في
                                    حالة بدل الفاقد</h6> </label>
                            <input type="file" name="school_certificat" class="dropify" accept="image/*"
                                data-height="70" />
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-center">
                    <button type="submit"
                        class="btn btn-primary btn-lg">{{ trans('Certificat_trans.submit') }}</button>
                </div>

                {!! Form::close() !!}

            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
<script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
<!--Internal Fancy uploader js-->
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>

<script>
    $(document).ready(function() {

        $('#en').hide();
        $('#ar').hide();

        $('input[type="checkbox"]').click(function() {
            if ($(this).attr('id') == 'lang1') {
                $('#ar').show();
            } else if ($(this).attr('id') == 'lang2') {
                $('#en').show();
            }

        });
    });
</script>

@endsection
