@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Certificat_trans.title_page') }} - {{ trans('Certificat_trans.Certificates_complate') }}
@stop
@endsection  
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.title_page') }} / {{ trans('Certificat_trans.Certificates_complate') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th> 
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Delivery_trans.request_date') }}</th>
                                <th>{{ trans('Delivery_trans.deliver_date') }}</th>
                                <th>الموظف</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($certificats as $index => $certificat)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    @if (isset($certificat->first_name[0]))
                                    <td>{{ $certificat->first_name[0] }} {{ $certificat->second_name[0] }} {{ $certificat->midell_name[0] }} {{ $certificat->last_name[0] }}</td>
                                    @else
                                    <td>{{ $certificat->first_name[1] }} {{ $certificat->second_name[1] }} {{ $certificat->midell_name[1] }} {{ $certificat->last_name[1] }}</td>
                                    @endif
                                    <td>
                                        @if ($certificat->certificat_type == ["1"])
                                        {{ trans('Certificat_trans.Details') }}
                                        @elseif ($certificat->certificat_type == ["2"])
                                        {{ trans('Certificat_trans.Regular') }}
                                        @else
                                                {{ trans('Certificat_trans.Regular') }} - {{ trans('Certificat_trans.Details') }}
                                        @endif
                                    </td>
                                    <td>{{ $certificat->dept->name }}</td> 

                                    <td>{{ date('d-m-Y', strtotime($certificat->created_at)) }}</td>
                                    <td>{{ date('d-m-Y', strtotime($certificat->updated_at)) }}</td>
                                    <td>{{ $certificat->emp_id }}</td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['certificats.destroy', $certificat->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id" class="form-control">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
   
-->

</div>
<!-- row closed -->
@endsection
@section('js')
<script>
    $('#delete').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget)
        var id = button.data('id')
        var personal_image = button.data('personal_image')
        var bank = button.data('bank')
        var ssn = button.data('ssn')
        var school_certificat = button.data('school_certificat')
        var modal = $(this)

        modal.find('.modal-body #id').val(id);
        modal.find('.modal-body #personal_image').val(personal_image);
        modal.find('.modal-body #bank').val(bank);
        modal.find('.modal-body #ssn').val(ssn);
        modal.find('.modal-body #school_certificat').val(school_certificat);
    })

</script>

@toastr_js
@toastr_render
@endsection
