@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
    {{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
@section('PageTitle')
    {{ trans('Certificat_trans.title_page') }}
@stop
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.title_page') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#"
                        class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <a href="{{ route('payments.index') }}">
            <button type="button" class="btn btn-primary l-t-20">
                {{ trans('main_trans.back') }}
            </button>
        </a>
        <br><br>
        <div class="card card-statistics h-100">

            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                {!! Form::open(['route' => 'payments.store', 'autocomplete' => 'off', 'files' => 'ture']) !!}

                @csrf

                <div class="row">

                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.guraduate_year') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="course" id="course" class="custom-select" class="custom-select"
                                aria-label="Default select example">
                                <option selected disabled>{{ trans('main_trans.Choose') }}</option>
                                @foreach ($courses as $key => $value)
                                    <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>{{ trans('Certificat_trans.admission_year') }} : <span
                                    class="text-danger">*</span></label>
                            <select name="code" id="code" class="custom-select" class="custom-select"
                                aria-label="Default select example">
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Amount : <span class="text-danger">*</span></label>
                            <input class="form-control" name="amount" type="number" value="{{ old('amount') }}">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Quantity : <span class="text-danger">*</span></label>
                            <input class="form-control" name="qty" type="number" value="{{ old('qty') }}">
                        </div>
                    </div>
                </div>
                <p class="text-danger">* صيغة المرفقات: jpeg ,jpg , png </p>
                <div class="row">

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="file">{{ trans('Certificat_trans.personal_image') }} : <span
                                    class="text-danger">*</span></label>
                            <input type="file" name="file" class="dropify" accept="image/*" data-height="70" />
                        </div>
                    </div>
                </div><br>
                <div class="d-flex justify-content-center">
                    <button type="submit" class="btn btn-primary btn-lg">Add</button>
                </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
<script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
<!--Internal Fancy uploader js-->
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
<script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>

<script>
    $(document).ready(function() {

        $('select[name="course"]').on('change', function() {

            var course = $(this).val();

            if (course) {

                $.ajax({
                    url: '/getcodes/' + course,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        console.log(data);
                        $('select[name="code"]').empty();
                        $.each(data, function(key, value) {
                            $('select[name="code"]')
                                .append('<option value="' + key + '">' + value +
                                    '</option>');
                        });
                    }

                });

            } else {
                $('select[name="code"]').empty();
            }

        });
    });
</script>

@endsection
