@if ($currentStep != 1)
    <div style="display: none" class="row setup-content" id="step-1">
@endif
<div class="col-xs-12">
    <div class="form-row">
        <div class="col">
            <label for="title">{{ trans('Students_trans.name_ar') }}</label>
            <input type="text" wire:model="name" class="form-control">
            @error('name')
                <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>
        <div class="col">
            <label for="title">{{ trans('Students_trans.name_en') }}</label>
            <input type="text" wire:model="name_en" class="form-control">
            @error('name_en')
                <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>
    </div>

    <div class="col-md-12">
        <br>
        <div class="form-row">
            <div class="col">
                <label for="title">{{ trans('Students_trans.email') }}</label>
                <input type="email" wire:model="email" class="form-control">
                @error('email')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
            <div class="col">
                <label for="title">{{ trans('Students_trans.password') }}</label>
                <input type="password" wire:model="password" class="form-control">
                @error('password')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
        </div>


        <div class="form-row">
            <div class="col-md-3">
                <label for="title">{{ trans('Students_trans.phone') }}</label>
                <input type="text" wire:model="phone" class="form-control">
                @error('phone')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
            <div class="col-md-3">
                <label for="title">{{ trans('Students_trans.ssn') }}</label>
                <input type="text" wire:model="ssn" class="form-control">
                @error('ssn')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>


            <div class="col">
                <label for="title">{{ trans('Students_trans.birth_date') }}</label>
                <input type="text" wire:model="birth_date" class="form-control">
                @error('birth_date')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="col">
                <label for="title">{{ trans('Students_trans.gender') }}</label>
                <select class="custom-select my-1 mr-sm-2" wire:model="gender_id">
                    <option selected>{{ trans('Students_trans.Choose') }}...</option>
                     @foreach ($genders as $gender)
                        <option value="{{ $gender->id }}">{{ $gender->name }}</option>
                    @endforeach
                </select>
                @error('gender')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

        </div>


        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="inputCity">{{ trans('Students_trans.dept') }}</label>
                <select class="custom-select my-1 mr-sm-2" wire:model="dept_id">
                    <option selected>{{ trans('Students_trans.Choose') }}...</option>
                    @foreach ($depts as $dept)
                        <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                    @endforeach
                </select>
                @error('dept')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group col-md-3">
                <label for="inputCity">{{ trans('Students_trans.Nationality') }}</label>
                <select class="custom-select my-1 mr-sm-2" wire:model="nationalitie_id">
                    <option selected>{{ trans('Students_trans.Choose') }}...</option>
                    @foreach ($Nationalities as $National)
                        <option value="{{ $National->id }}">{{ $National->name }}</option>
                    @endforeach
                </select>
                @error('Nationality')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>

            <div class="form-group col">
                <label for="inputState">{{ trans('Students_trans.blood_type') }}</label>
                <select class="custom-select my-1 mr-sm-2" wire:model="blood_id">
                    <option selected>{{ trans('Students_trans.Choose') }}...</option>
                    @foreach ($Bloods as $Blood)
                        <option value="{{ $Blood->id }}">{{ $Blood->name }}</option>
                    @endforeach
                </select>
                @error('blood_type')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
            <div class="form-group col">
                <label for="inputZip">{{ trans('Students_trans.Religion') }}</label>
                <select class="custom-select my-1 mr-sm-2" wire:model="religion_id">
                    <option selected>{{ trans('Students_trans.Choose') }}...</option>
                    @foreach ($Religions as $Religion)
                        <option value="{{ $Religion->id }}">{{ $Religion->name }}</option>
                    @endforeach
                </select>
                @error('Religion')
                    <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </div>
        </div>


        <div class="form-group">
            <label for="exampleFormControlTextarea1">{{ trans('Students_trans.Address') }}</label>
            <textarea class="form-control" wire:model="address" id="exampleFormControlTextarea1" rows="4"></textarea>
            @error('Address')
                <div class="alert alert-danger">{{ $message }}</div>
            @enderror
        </div>

        @if($updateMode)
             <button class="btn btn-success btn-lg nextBtn btn-lg pull-right" wire:click="firstStepSubmit_edit"
                type="button">{{trans('Students_trans.Next')}}
            </button>
         @else
             <button class="btn btn-success btn-lg nextBtn btn-lg pull-right" wire:click="firstStepSubmit"
                type="button">{{trans('Students_trans.Next')}}
             </button>
        @endif



    </div>
</div>
</div>