<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('labs', function(Blueprint $table) {
			$table->foreign('unit_id')->references('id')->on('units')->onDelete('cascade');
			$table->foreign('year_id')->references('id')->on('years')->onDelete('cascade');
			
		});
		// Schema::table('categories', function(Blueprint $table) { 
		// 	$table->foreign('lab_id')->references('id')->on('labs')->onDelete('cascade');			
		// });
		Schema::table('courses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
		});
		Schema::table('codes', function(Blueprint $table) { 
			$table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
			$table->foreign('lab_id')->references('id')->on('labs')->onDelete('cascade');
			$table->foreign('year_id')->references('id')->on('labs')->onDelete('cascade');
		});
		
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('code_id')->references('id')->on('codes')->onDelete('cascade');
			$table->foreign('course_id')->references('id')->on('categories')->onDelete('cascade');
			$table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
			$table->foreign('lab_id')->references('id')->on('labs')->onDelete('cascade');
		});

	}

	

	public function down()
	{

		Schema::table('labs', function(Blueprint $table) {
			$table->dropForeign('labs_unit_id_foreign');
			$table->dropForeign('labs_year_id_foreign');
		});
		// Schema::table('categories', function(Blueprint $table) {
		// 	$table->dropForeign('categories_lab_id_foreign');
		// });

		Schema::table('courses', function(Blueprint $table) {
			$table->dropForeign('courses_category_id_foreign');
		});
		Schema::table('codes', function(Blueprint $table) {
			$table->dropForeign('codes_course_id_foreign');
			$table->dropForeign('codes_lab_id_foreign');
		});
		
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('labs_code_id_foreign');
			$table->dropForeign('labs_course_id_foreign');
			$table->dropForeign('labs_user_id_foreign');
			$table->dropForeign('labs_lab_id_foreign');
		});
       
	}


}
