<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Verification;

class VerificationUpdate extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
       // $this->certificat_id = decrypt($certificat_id);
         $url = 'https://certificats.eust.edu.sd/ar/verifications';

        return (new MailMessage)                 
                    ->subject('نتيجة التحقق الأكاديمي')
                    ->line('ظهور نتيجة التحقق الأكاديمي الخاص بك ، يرجى مراجعة نظام الشهادات')
                    ->action('عرض التحقق الاكاديمي', $url)
                    ->line('شكرا لاستخدامك نظام الشهادات بكلية الامارات للعلوم و التكنولوجيا');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
