<?php

namespace App\Http\Controllers;

use App\Models\Code;
use App\Http\Requests\StoreCodeRequest;
use App\Http\Requests\UpdateCodeRequest;

class CodeController extends Controller
{
    function __construct()
    { 

    $this->middleware('permission:show code', ['only' => ['index']]);
    $this->middleware('permission:add code', ['only' => ['create','store']]);
    $this->middleware('permission:update code', ['only' => ['edit','update']]);
    $this->middleware('permission:delete code', ['only' => ['destroy']]);

    }
   
    public function index()
    {
        $codes =  Code::all();
        return view('pages.Codes.index',compact('codes'));
    }

    public function create()
    {
        //
    }

   
    public function store(StoreCodeRequest $request)
    {
        //
    }

   
    public function show($id)
    {
        $code = Code::find(decrypt($id));
        return view('pages.Codes.show',compact('code'));
    }

   
    public function edit(Code $code)
    {
        //
    }

    
    public function update(UpdateCodeRequest $request, Code $code)
    {
        //
    }

   
    public function destroy(Code $code)
    {
        //
    }
}
