<?php

namespace App\Http\Controllers;

use App\Models\Certificat; 
use App\Models\Register;
use App\Models\Record;
use App\Models\Statment;
use App\Models\Dept;
use App\Models\Year;
use App\Models\User;
use App\Http\Requests\StoreCertificatRequest;
use App\Http\Requests\UpdateCertificatRequest;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Image;
use Illuminate\Support\Facades\DB;
use App\Exports\CertificatsExport;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Notification;
use App\Notifications\CertificatCreate;
use App\Notifications\CertificatProcessResult; 
use App\Notifications\CertificatProcessPay;
use App\Notifications\CertificatPrint;
use App\Exports\CertificatRejectExport;

class CertificatController extends Controller
{
    function __construct()
    { 
    //CertificatProcessResult  CertificatProcessPay
    $this->middleware('permission:عرض شهادة', ['only' => ['index']]);
    $this->middleware('permission:اضافة شهادة', ['only' => ['create','store']]);
    $this->middleware('permission:تعديل شهادة', ['only' => ['edit','update']]);
    $this->middleware('permission:حذف شهادة', ['only' => ['destroy']]);
    $this->middleware('permission:المالية', ['only' => ['CertificatProcessPay']]);
    $this->middleware('permission:النتيجة', ['only' => ['CertificatProcessResult']]);
    }
    public function index()
    {
        if(Auth::user()->user_type == 'stu')
        {
            $certificats = Certificat::where('user_id', Auth::user()->id)->get();

        }
        else
        {
           
            $certificats = Certificat::where('r_status',0)
            ->Orwhere('f_status',0)
            ->Orwhere('f_status',2)
            ->Orwhere('r_status',2)
            ->get();

        }
        return view('pages.Certificat.index',compact('certificats'));
    }

    
    public function create()
    {
        $depts =  Dept::all();
        $years =  Year::all();
       
        return view('pages.Certificat.create',compact('depts','years'));
    }

   
    public function store(StoreCertificatRequest $request)
    {
        
       
        if(Certificat::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم مسبقاً');
        }
        elseif(Register::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لسجل اكاديمي مسبقاً');
        }
        elseif(Record::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لأستخراج شهادة قيد');
        }
        elseif(Statment::where('user_id',Auth::user()->id)->exists())
        {
           return redirect()->back()->withErrors('تم التقديم لافادة تخرج مسبقاً');
        }
        try {
            DB::beginTransaction();
            $validated = $request->validated();

            $certificat = new Certificat; 

            $certificat->midell_name =  $request->midell_name;
            $certificat->second_name = $request->second_name;
            $certificat->first_name = $request->first_name;
            $certificat->last_name = $request->last_name;
            $certificat->certificat_type = $request->certificat_type;
            $certificat->lang =$request->lang;
            $certificat->dept_id = Auth::user()->dept_id;
            $certificat->admission_year = $request->admission_year;
            $certificat->guraduate_year = $request->guraduate_year;
            $certificat->user_id = Auth::user()->id;
            $certificat->amount =$request->amount;
            $certificat->notification_number =$request->notification_number;
            $certificat->certificat_number =$request->certificat_number;
            $certificat->print ='0';
                
           
            if ($request->hasFile('personal_image')) {
                $image = $request->file('personal_image');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/personalImage/' . $filename;
                Image::make($image)->resize(500, 500)->save($location);
                $certificat->personal_image = $filename;
            }  
            if ($request->hasFile('bank')) {
                $image = $request->file('bank');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $certificat->bank = $filename;
            } 
            if ($request->hasFile('ssn')) {
                $image = $request->file('ssn');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $certificat->ssn = $filename;
            }  
            if ($request->hasFile('school_certificat')) {
                $image = $request->file('school_certificat');
                $filename = time() . '.' . $image->getClientOriginalExtension();
                $location = '/home/eustedu/certificats.eust.edu.sd/images/schoolCertificat/' . $filename;
                Image::make($image)->resize(500, 600)->save($location);
                $certificat->school_certificat = $filename;
            }  
            
            $certificat->save();

            //send Notification
           
            $user = User::where('id',Auth::user()->id)->first();
            Notification::send($user, new \App\Notifications\CertificatCreate);

            $user = User::where('id', Auth::user()->id)->first();
            $user->update([
            'certificats' => '1',
                ]);
                DB::commit();
                toastr()->success(trans('messages.success'));
                return redirect()->route('certificats.index');
               }
    
           

            catch (\Exception $e){
             DB::rollback();
            return redirect()->back()->withErrors(['error' => $e->getMessage()]);
             }
    }

   
    public function show($id)
    {
        $certificat = Certificat::find(decrypt($id));
        return view('pages.Certificat.show',compact('certificat'));
    }
    
   
   
    //public function edit(Certificat $certificat)
    public function edit( $id)
    {
        
        $certificat = Certificat::find(decrypt($id));
        $depts =  Dept::all();
        $years =  Year::all();
        return view('pages.Certificat.edit',compact('certificat','depts','years'));
    }

   
    public function update(UpdateCertificatRequest $request, Certificat $certificat)
    {
        
        try {
           
            // $certificat->first_name = $request->first_name;
            // $certificat->second_name = $request->second_name;
            // $certificat->midell_name = $request->midell_name;
            // $certificat->last_name = $request->last_name;
            // $certificat->dept_id = Auth::user()->dept_id;
            // $certificat->admission_year = $request->admission_year;
            // $certificat->guraduate_year = $request->guraduate_year;
            // $certificat->amount =$request->amount;
            // $certificat->notification_number =$request->notification_number;
            // $certificat->certificat_number =$request->certificat_number;
            // $certificat->print =0;
           // $certificat->certificat_type = $request->certificat_type;
                
                if ($request->hasFile('personal_image')) {
                    Storage::delete($certificat->personal_image);
                    $image = $request->file('personal_image');
                    $filename = time() . '.' . $image->getClientOriginalExtension();
                     $location = '/home/eustedu/certificats.eust.edu.sd/images/personalImage/' . $filename;
                    Image::make($image)->resize(500, 500)->save($location);
                    $certificat->personal_image = $filename;

                }  

                if ($request->hasFile('bank')) {
                    Storage::delete($certificat->bank);
                    $image = $request->file('bank');
                    $filename = time() . '.' . $image->getClientOriginalExtension();
                    $location ='/home/eustedu/certificats.eust.edu.sd/images/bank/' . $filename;
                    Image::make($image)->resize(500, 600)->save($location);
                    $certificat->bank = $filename;
                } 
                if ($request->hasFile('ssn')) {
                    Storage::delete($certificat->ssn);
                    $image = $request->file('ssn');
                    $filename = time() . '.' . $image->getClientOriginalExtension();
                    $location = '/home/eustedu/certificats.eust.edu.sd/images/ssn/' . $filename;
                    Image::make($image)->resize(500, 600)->save($location);
                    $certificat->ssn = $filename;
                }  
                if ($request->hasFile('school_certificat')) {
                   // Storage::delete($certificat->school_certificat);
                    $image = $request->file('school_certificat');
                    $filename = time() . '.' . $image->getClientOriginalExtension();
                    $location = '/home/eustedu/certificats.eust.edu.sd/images/schoolCertificat/' . $filename;
                    Image::make($image)->resize(500, 600)->save($location);
                    $certificat->school_certificat = $filename;
                }

                $certificat->save();
                
            toastr()->success(trans('messages.Update')); 
            return redirect()->route('certificats.index');
            }
            catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }
    }

   
    public function destroy(Request $request)
    {
        
        try {
            $certificat = Certificat::where('id',$request->id)->first();
            $certificat->update([
            'deleted_id' => (Auth::user()->id),
                ]);
             $certificat->delete();
             toastr()->error(trans('messages.Delete'));
            return redirect()->route('certificats.index');
        }

        catch (\Exception $e){
        return redirect()->back()->withErrors(['error' => $e->getMessage()]);
        }

    }

    public function CertificatProcessResult(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة الأكاديمية للشهادة',
            
            ]);
           try {
                $certificat = Certificat::where('id',$request->id)->first();
                $certificat->update([
                'r_status' => $request->rdio,
                'r_note' => $request->note,
                'acdimec_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                
                $user = User::where('id',$certificat->user_id)->first();
                 Notification::send($user, new \App\Notifications\CertificatProcessResult);

                toastr()->success(trans('messages.success'));
                return redirect('/certificats');

    }
    
    public function CertificatProcessPay(Request $request)
    {
       
            $validatedData = $request->validate([
                'rdio' => 'required',
            ],[

                'rdio.required' =>'يرجي تحديد الحالة المالية للشهادة',
            
            ]);
           try {
                $certificat = Certificat::where('id',$request->id)->first();
                $certificat->update([
                'f_status' => $request->rdio,
                'f_note' => $request->note,
                'bank_user'=> Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                $user = User::where('id',$certificat->user_id)->first();
                 Notification::send($user, new \App\Notifications\CertificatProcessPay);

                toastr()->success(trans('messages.success'));
                return redirect('/certificats');

    }

    public function export() 
    {
        return Excel::download(new CertificatsExport, 'CertificatsExports.xlsx');
    }
    public function ArchiveCertificat() 
    {
        $certificats = Certificat::onlyTrashed()->get();
        return view('pages.Certificat.ArchiveCertificat',compact('certificats'));
       
    }
    public function Printcertificat($id) 
    {
        $certificat = Certificat::findOrFail($id);
        $certificat->update([
        'print' => '1',
            ]);
            
        $user = User::where('id',$certificat->user_id)->first();
        Notification::send($user, new \App\Notifications\CertificatPrint);
            
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
     public function RestorCertificat(Request $request) 
    {
       $id=$request->id;
        $certificat = Certificat::withTrashed()->where('id', $id)->restore();
      
        toastr()->success(trans('messages.success'));
        return redirect()->back();
    }
    
     public function CommentCertificat(Request $request)
    {
           try {
                $certificat = Certificat::where('id',$request->id)->first();
                $certificat->update([
                'comments' => $request->comments,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                
                // $user = User::where('id',$certificat->user_id)->first();
                //  Notification::send($user, new \App\Notifications\CertificatProcessResult);

                toastr()->success(trans('messages.success'));
                return redirect('/certificats');

    }
     public function CertificatDelivery($id)
    {       
        $certificat_id= decrypt($id);
           try {
                
                $certificat = Certificat::where('id',$certificat_id)->first();
                $certificat->update([
                'delivery_status' => '1',
                'emp_id' => Auth::user()->id,
                    ]);
                }
                
                catch (\Exception $e){
                return redirect()->back()->withErrors(['error' => $e->getMessage()]);
                }

                toastr()->success(trans('messages.success'));
                return redirect()->back();

    }

    public function CertificatComplate()
    {       
        $certificats = Certificat::where('f_status','1')
        ->where('r_status','1')
        ->where('print','1')
        ->where('delivery_status','1')
        ->get();
        
        return view('pages.Certificat.CertificatesComplate',compact('certificats'));

    }
    public function CertificatReject()
    {       
        $certificats = Certificat::where('f_status','2')
        ->orWhere('r_status','2')
        ->get();
        
        return view('pages.Certificat.CertificatReject',compact('certificats'));

    }
    public function exportCertificatReject() 
    {
        return Excel::download(new CertificatRejectExport, 'CertificatRejectExport.xlsx');
    }

}//end of Controller 
