<!DOCTYPE html>
<html lang="en">
<title><?php echo e(trans('main_trans.Dashboard')); ?></title>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="كلية الامارات للعلوم و التكنولوجيا" />
    <meta name="description" content="كلية الامارات للعلوم و التكنولوجيا - نظام الشهادات" />
    <meta name="author" content="www.eust.edu.sd" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <?php echo $__env->make('layouts.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>

    <div class="wrapper">

        <!--=================================
 preloader -->

        <div id="pre-loader">
            <img src="assets/images/pre-loader/loader-01.svg" alt="">
        </div>

        <!--=================================
 preloader -->

        <?php echo $__env->make('layouts.main-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('layouts.main-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--=================================
 Main content -->
        <!-- main-content -->
        <div class="content-wrapper">
            <div class="page-title">
               
            </div>
            <!-- widgets -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isAdmin')): ?>
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-danger">
                                        <i class="fa fa-user-o highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('main_trans.student')); ?></p>
                                    <h4>65,650</h4>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-warning">
                                        <i class="ti-id-badge highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('main_trans.Order')); ?></p>
                                    <h4>656</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-success">
                                        <i class="fa fa-server highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('Depts_trans.title_page')); ?></p>
                                    <h4>13</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-primary">
                                        <i class="fa fa-user highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('Users_trans.user')); ?></p>
                                    <h4>8</h4>
                                </div>
                            </div>
                         
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isEmp')): ?>
            <div class="row">
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-danger">
                                        <i class="fa fa-user-o highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('main_trans.student')); ?></p>
                                    <h4>65,650</h4>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-warning">
                                        <i class="ti-id-badge highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('main_trans.Order')); ?></p>
                                    <h4>656</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-success">
                                        <i class="fa fa-server highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('Depts_trans.title_page')); ?></p>
                                    <h4>13</h4>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6 mb-30">
                    <div class="card card-statistics h-100">
                        <div class="card-body">
                            <div class="clearfix">
                                <div class="float-left">
                                    <span class="text-primary">
                                        <i class="fa fa-user highlight-icon" aria-hidden="true"></i>
                                    </span>
                                </div>
                                <div class="float-right text-right">
                                    <p class="card-text text-dark"><?php echo e(trans('Users_trans.user')); ?></p>
                                    <h4>8</h4>
                                </div>
                            </div>
                         
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            <!-- Orders Status widgets-->
            
          
          

            <div class="calendar-main mb-30">
                <div class="row">
                    
                    
                    <div class="col-lg-6">
                        <div>
                            <span class="text-success"><?php echo e(trans('main_trans.info')); ?></span>
                        </div>
                        <div class="accordion gray plus-icon round">
                            <div class="acd-group acd-active">
                              <a href="#" class="acd-heading"><?php echo e(trans('main_trans.text1')); ?> :</a>
                              <div class="acd-des" style="">
                                <span><?php echo e(trans('Certificat_trans.text7')); ?> </span><br>
                                <span><?php echo e(trans('main_trans.text2')); ?> </span><br>
                                <span><?php echo e(trans('main_trans.text3')); ?> </span><br>
                                <span><?php echo e(trans('main_trans.text4')); ?> </span><br>
                                <span><?php echo e(trans('main_trans.text5')); ?> </span><br>
                                <span><?php echo e(trans('main_trans.text6')); ?> </span><br>
                                
                               </div>
                            </div>
                            <div class="acd-group">
                              <a href="#" class="acd-heading"><?php echo e(trans('Certificat_trans.text1')); ?> :</a>
                              <div class="acd-des" style="display: none;"> 
                                <span><?php echo e(trans('Certificat_trans.personal_image')); ?> </span><br>
                                <span><?php echo e(trans('Certificat_trans.bank')); ?></span><br>
                                  <span><?php echo e(trans('Certificat_trans.ssn')); ?></span><br>
                            </div>
                            </div>
                            <div class="acd-group">
                              <a href="#" class="acd-heading"><?php echo e(trans('Certificat_trans.text4')); ?> :</a>
                              <div class="acd-des" style="display: none;">
                                <?php echo e(trans('Certificat_trans.text5')); ?> <br>
                                <?php echo e(trans('Certificat_trans.text7')); ?>

                            </div>
                            </div>
                          </div>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isUser')): ?>
                    <div class="col-lg-6">
                       
                        
                        <div class="row">
                            <div class="col-12 sm-mb-30">
                                <strong><strong><?php echo e(trans('Certificat_trans.text3')); ?></strong></strong>
                            </div>
                        </div>
                        
                        <?php if($certificats->count() > 0): ?> 
                        <?php echo e(trans('main_trans.certificat_request')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(trans('Certificat_trans.certificat_type')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Result_process')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Pay_process')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $certificats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $certificat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            <td>
                                                <?php if($certificat->certificat_type == ["1"]): ?>
                                                <?php echo e(trans('Certificat_trans.Details')); ?>

                                                <?php elseif($certificat->certificat_type == ["2"]): ?>
                                                <?php echo e(trans('Certificat_trans.Regular')); ?>

                                                <?php else: ?>
                                                        <?php echo e(trans('Certificat_trans.Regular')); ?> - <?php echo e(trans('Certificat_trans.Details')); ?>

                                                <?php endif; ?>
                                            </td> 
                                            <td>
                                                <?php if($certificat->r_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Certificat_trans.Process')); ?>

                                                    </span>
                                                <?php elseif($certificat->r_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Certificat_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                    <span class="label text-danger">
                                                        <?php echo e(trans('Certificat_trans.reject')); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($certificat->f_status == '0'): ?>
                                                    <span class="label text-info">
                                                        <?php echo e(trans('Certificat_trans.Process')); ?>

                                                    </span>
                                                <?php elseif($certificat->f_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Certificat_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                    <span class="label text-danger">
                                                        <?php echo e(trans('Certificat_trans.reject')); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('certificats.show', encrypt($certificat->id))); ?>">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    
                                                    title="<?php echo e(trans('Certificat_trans.show')); ?>"><i
                                                        class="fa fa-eye"> <?php echo e(trans('Statment_trans.show')); ?> </i></button>
                                            </td>
                                  
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                       
                        <?php endif; ?>
                        
                        <?php if($registers->count() > 0): ?>
                        <?php echo e(trans('main_trans.Register_request')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(trans('Register_trans.language')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Result_process')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Pay_process')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                       
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $registers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $register): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td> 
                                            <td>
                                                <?php if($register->lang == '1'): ?>
                                                        
                                                         <?php echo e(trans('Register_trans.Arabic')); ?>

                                                <?php else: ?>
                                                <?php echo e(trans('Register_trans.English')); ?>

                                                <?php endif; ?>
                                            </td>
                                           
                                            <td>
                                                <?php if($register->r_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($register->r_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($register->f_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($register->f_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('registers.show', encrypt($register->id))); ?>">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="<?php echo e(trans('Statment_trans.show')); ?>"><i
                                                        class="fa fa-eye"> <?php echo e(trans('Statment_trans.show')); ?> </i></button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($records->count() > 0): ?>
                        <?php echo e(trans('Record_trans.record')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(trans('Register_trans.language')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Result_process')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Pay_process')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td> 
                                            <td>
                                                <?php if($record->lang == '1'): ?>
                                                        
                                                         <?php echo e(trans('Register_trans.Arabic')); ?>

                                                <?php else: ?>
                                                <?php echo e(trans('Register_trans.English')); ?>

                                                <?php endif; ?>
                                            </td>
                                           
                                            <td>
                                                <?php if($record->r_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($record->r_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($record->f_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($record->f_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('records.show', encrypt($record->id))); ?>">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="<?php echo e(trans('Statment_trans.show')); ?>"><i
                                                        class="fa fa-eye"> <?php echo e(trans('Statment_trans.show')); ?> </i></button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($statments->count() > 0): ?>
                        <?php echo e(trans('Record_trans.statment')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(trans('Statment_trans.Result_process')); ?></th>
                                        <th><?php echo e(trans('Statment_trans.Pay_process')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $statments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $statment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td> 
                                            
                                            <td>
                                                <?php if($statment->r_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($statment->r_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($statment->f_status == '0'): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($statment->f_status == '1'): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('statments.show', encrypt($statment->id))); ?>">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="<?php echo e(trans('Statment_trans.show')); ?>"><i
                                                        class="fa fa-eye"></i> <?php echo e(trans('Statment_trans.show')); ?> </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                        <?php endif; ?>
                        
                         
                        <?php if($deliveries->count() > 0): ?>
                        <?php echo e(trans('Delivery_trans.request_deliveries')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                         <th><?php echo e(trans('Delivery_trans.deliver_name')); ?></th>
                                        <th><?php echo e(trans('Delivery_trans.request_date')); ?></th>
                                        <th><?php echo e(trans('Delivery_trans.stauts')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $deliveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $delivery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td> 
                                             <td><?php echo e($delivery->first_name); ?> <?php echo e($delivery->second_name); ?> <?php echo e($delivery->midell_name); ?> <?php echo e($delivery->last_name); ?></td>
                                            <td><?php echo e(date('d-m-Y', strtotime($delivery->created_at))); ?></td>
                                            <td>
                                                <?php if($delivery->stutus == 0): ?>
                                                    <span class="label text-info">
                                                         <?php echo e(trans('Statment_trans.processing')); ?>

                                                    </span>
                                                <?php elseif($delivery->stutus == 1): ?>
                                                <span class="label text-success">
                                                    <?php echo e(trans('Statment_trans.complate')); ?>

                                                </span>
                                                <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Statment_trans.reject')); ?>

                                                </span>
                                                <?php endif; ?>
                                            </td>
                                           
                                            <td>
                                                <a href="<?php echo e(route('deliveries.show', encrypt($delivery->id))); ?>">
                                                    <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                                    title="<?php echo e(trans('Statment_trans.show')); ?>"><i
                                                        class="fa fa-eye"></i> <?php echo e(trans('Statment_trans.show')); ?> </button>
                                                 <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isUser')): ?> 
                                       <a href="<?php echo e(route('deliveries.edit', encrypt($delivery->id))); ?>">
                                        <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                        
                                        title="<?php echo e(trans('Statment_trans.Edit')); ?>"><i
                                            class="fa fa-edit"> <?php echo e(trans('Statment_trans.Edit')); ?></i></button>
                                       </a>
                                       <?php endif; ?>
                                       
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                        <?php endif; ?>
                        
                         
                        <?php if($documents->count() > 0): ?>
                        <?php echo e(trans('Document_trans.create')); ?>

                        <div class="row">
                            <table class="table table-striped table-bordered p-0">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(trans('Certificat_trans.date')); ?></th>
                                        <th><?php echo e(trans('Document_trans.documents_prosess')); ?></th>
                                        <th><?php echo e(trans('Certificat_trans.bank_note')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                    </tr>
                                </thead>
                                <tboby>
                                    <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                      
                                        <td><?php echo e(date('d-m-y', strtotime($document->created_at))); ?></td>
                                       
                                        <td>
                                            <?php if($document->stutus == '0'): ?>
                                                <span class="label text-info">
                                                     <?php echo e(trans('Certificat_trans.Process')); ?>

                                                </span>
                                            <?php elseif($document->stutus == '1'): ?>
                                            <span class="label text-success">
                                                <?php echo e(trans('Certificat_trans.complate')); ?>

                                            </span>
                                            <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Certificat_trans.reject')); ?>

                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($document->f_status == '0'): ?>
                                                <span class="label text-info">
                                                     <?php echo e(trans('Certificat_trans.Process')); ?>

                                                </span>
                                            <?php elseif($document->f_status == '1'): ?>
                                            <span class="label text-success">
                                                <?php echo e(trans('Certificat_trans.complate')); ?>

                                            </span>
                                            <?php else: ?>
                                                <span class="label text-danger">
                                                    <?php echo e(trans('Certificat_trans.reject')); ?>

                                                </span>
                                            <?php endif; ?>
                                        </td>
                                       
                                        <td>
                                          
                                           <a href="<?php echo e(route('documents.show', encrypt($document->id))); ?>">
                                            <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                            
                                            title="<?php echo e(trans('Certificat_trans.show')); ?>"><i
                                                class="fa fa-eye"> <?php echo e(trans('Statment_trans.show')); ?></i></button>
                                           </a>
                                          
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tboby>
                            </table>
                        </div>
                        <?php endif; ?>
                        
                        
                         <?php if($refunds->count() > 0): ?>
                         <?php echo e(trans('Document_trans.create')); ?>

                         <div class="row">
                             <table class="table table-striped table-bordered p-0">
                                 <thead>
                                     <tr>
                                        <th> <?php echo e(trans('Refund_trans.doc')); ?> </th>
                                        <th><?php echo e(trans('Delivery_trans.request_date')); ?></th>
                                        <th><?php echo e(trans('Delivery_trans.stauts')); ?></th>
                                        <th><?php echo e(trans('Depts_trans.Processes')); ?></th>
                                     </tr>
                                 </thead>
                                 <tboby>
                                     <?php $__currentLoopData = $refunds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $refund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                     <tr>
                                        <td>
                                            <?php if($refund->type == '1'): ?>
                                                <span class="label text-info">
                                                    <?php echo e(trans('Refund_trans.Certificat')); ?>

                                                </span>
                                            <?php elseif($refund->type == '2'): ?>
                                            <span class="label text-info">
                                                <?php echo e(trans('Refund_trans.Statment')); ?>

                                            </span>
                                            <?php elseif($refund->type == '3'): ?>
                                            <span class="label text-info">
                                                <?php echo e(trans('Refund_trans.Record')); ?>

                                            </span>
                                            <?php else: ?>
                                            <span class="label text-info">
                                                <?php echo e(trans('Refund_trans.Register')); ?> 
                                            </span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($refund->created_at); ?></td>
                                        <td>
                                            <?php if($refund->stutus == '0'): ?>
                                                <span class="label text-info">
                                                     <?php echo e(trans('Statment_trans.processing')); ?>

                                                </span>
                                            <?php elseif($refund->stutus == '1'): ?>
                                            <span class="label text-success">
                                                <?php echo e(trans('Statment_trans.complate')); ?>

                                            </span>
                                            <?php else: ?>
                                            <span class="label text-danger">
                                                <?php echo e(trans('Statment_trans.reject')); ?>

                                            </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                           <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('isAdmin')): ?> 
                                           <a href="<?php echo e(route('deliveries.edit', encrypt($refund->id))); ?>">
                                            <button  type="button" class="btn btn-info btn-sm" data-toggle="modal"
                                            title="<?php echo e(trans('Statment_trans.Edit')); ?>"><i
                                                class="fa fa-edit"></i></button>
                                           </a>
                                           <?php endif; ?>
                                           <a href="<?php echo e(route('refunds.show', encrypt($refund->id))); ?>">
                                            <button  type="button" class="btn btn-success btn-sm" data-toggle="modal"
                                            
                                            title="<?php echo e(trans('Statment_trans.show')); ?>"><i
                                                class="fa fa-eye"></i></button>
                                           </a>
                                        </td>
                                     </tr>
                                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </tboby>
                             </table>
                         </div>
                         <?php endif; ?>
                         
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <br> <br> <br> <br> <br> <br> <br> <br> <br>
            <!--=================================
 wrapper -->

            <!--=================================
 footer -->

            <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div><!-- main content wrapper end-->
    </div>
    </div>
    </div>

    <!--=================================
 footer -->

    <?php echo $__env->make('layouts.footer-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH /home/eustedu/Certificates/resources/views/dashboard.blade.php ENDPATH**/ ?>