<?php

use Illuminate\Support\Facades\Route;

    Route::get('registration', 'Auth\RegisterController@registration')->name('registration');
	
	
	//Route::post('reset-password', [ForgotPasswordController::class, 'submitResetPasswordForm'])->name('reset.password.post');

	Route::get('my-captcha', 'HomeController@myCaptcha')->name('myCaptcha');
    Route::post('my-captcha', 'HomeController@myCaptchaPost')->name('myCaptcha.post');
    Route::get('refresh_captcha', 'HomeController@refreshCaptcha')->name('refresh_captcha');

Route::group(['middleware'=>['guest']],function(){

	Route::get('/', function()
	{
	return view('auth.login');
	 });

});

Auth::routes(['verify' => true]);

Route::group(
	[
		'prefix' => LaravelLocalization::setLocale(),
		'middleware' => [ 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath', 'auth' ]
	], function()
	{ 
	
		Route::get('/dashboard', 'HomeController@index')->name('dashboard');

		Route::group(['namespace' => 'Grades'], function () {
			Route::resource('grades', 'GradeController');
		});
	    //===========================semesters============================

		Route::resource('semesters', 'SemesterController');
        //===========================roles============================
		Route::resource('roles','RoleController');

		
		
	    //==============================certificats============================
		Route::resource('certificats', 'CertificatController');
		Route::post('CertificatProcessResult', 'CertificatController@CertificatProcessResult')->name('CertificatProcessResult');
		Route::post('CertificatProcessPay', 'CertificatController@CertificatProcessPay')->name('CertificatProcessPay');
		Route::get('certificatexport','CertificatController@export')->name('certificatexport');
		Route::get('ArchiveCertificat','CertificatController@ArchiveCertificat')->name('ArchiveCertificat');
		Route::get('RestorCertificat','CertificatController@RestorCertificat')->name('RestorCertificat');
		Route::get('Printcertificat/{id}','CertificatController@Printcertificat')->name('Printcertificat');
		Route::post('CommentCertificat','CertificatController@CommentCertificat')->name('CommentCertificat');
		Route::get('CertificatDelivery/{id}','CertificatController@CertificatDelivery')->name('CertificatDelivery');
		Route::get('CertificatComplate','CertificatController@CertificatComplate')->name('CertificatComplate');
		Route::get('CertificatReject','CertificatController@CertificatReject')->name('CertificatReject');
		Route::get('exportCertificatReject','CertificatController@exportCertificatReject')->name('exportCertificatReject');
		
		//===========================statments============================
		Route::resource('statments','StatmentController');
		Route::post('processresult', 'StatmentController@processresult')->name('processresult');
		Route::post('processpay', 'StatmentController@processpay')->name('processpay');
		Route::get('ArchiveStatment', 'StatmentController@ArchiveStatment')->name('ArchiveStatment');
		Route::get('RestorStatment','StatmentController@RestorStatment')->name('RestorStatment');
		Route::post('CommentStatment','StatmentController@CommentStatment')->name('CommentStatment');
	
		//===========================records============================
		Route::resource('records','RecordController');
		Route::post('processrecordresult', 'RecordController@processrecordresult')->name('processrecordresult');
		Route::post('processrecordpay', 'RecordController@processrecordpay')->name('processrecordpay');
		Route::get('ArchiveRecord', 'RecordController@ArchiveRecord')->name('ArchiveRecord');
		Route::get('RestoRrecord','RecordController@RestoRrecord')->name('RestoRrecord');
		Route::post('CommentRrecord','RecordController@CommentRrecord')->name('CommentRrecord');
		//==============================reports============================Archive Certificates_complate

		Route::resource('reports', 'ReportsController');
		Route::get('activities', 'ReportsController@activities')->name('activities');
		Route::get('statmentReport', 'ReportsController@statmentReport')->name('statmentReport');
		Route::get('recordsReport', 'ReportsController@recordsReport')->name('recordsReport');
		Route::get('certificatsReport', 'ReportsController@certificatsReport')->name('certificatsReport');
		Route::get('certificatsCount', 'ReportsController@certificatsCount')->name('certificatsCount');
		Route::get('documentsCount', 'ReportsController@documentsCount')->name('documentsCount');
        Route::get('GenralFinancialReport', 'ReportsController@GenralFinancialReport')->name('GenralFinancialReport');
		Route::get('registersCount', 'ReportsController@registersCount')->name('registersCount');
		Route::get('recordsCount', 'ReportsController@recordsCount')->name('recordsCount');
		Route::get('statmentsCount', 'ReportsController@statmentsCount')->name('statmentsCount');
		Route::get('certificatsPrint', 'ReportsController@certificatsPrint')->name('certificatsPrint');

		Route::get('student', 'ReportsController@student')->name('student');
		Route::get('student', 'ReportsController@student')->name('student');
	    Route::get('CertificatesRadyToDelver','ReportsController@CertificatesRadyToDelver')->name('CertificatesRadyToDelver');
		//Route::resource('customreports', 'ReportsController@all')->name('customreports');
		//==============================registers============================ 

		Route::resource('registers', 'RegisterController');
		Route::post('registerProcessResult', 'RegisterController@registerProcessResult')->name('registerProcessResult');
		Route::post('registerProcessPay', 'RegisterController@registerProcessPay')->name('registerProcessPay');
		Route::get('ArchiveRegister', 'RegisterController@ArchiveRegister')->name('ArchiveRegister');
		Route::get('RestoeRegister','RegisterController@RestoeRegister')->name('RestoeRegister');
		Route::post('CommentRegister','RegisterController@CommentRegister')->name('CommentRegister');
		//==============================depts============================ 

		Route::resource('depts', 'DeptController');

		//==============================deliveries============================ 

		Route::resource('deliveries', 'DeliveryController');
		Route::post('deliveryprocess', 'DeliveryController@deliveryprocess')->name('deliveryprocess');
	    Route::get('ArchivDelivery', 'DeliveryController@ArchivDelivery')->name('ArchivDelivery');
		Route::get('RestoerDelivery','DeliveryController@RestoerDelivery')->name('RestoerDelivery');
		Route::get('DeliveryComplate','DeliveryController@DeliveryComplate')->name('DeliveryComplate');
		//==============================students============================ 

		Route::resource('students', 'StudentController');
		Route::get('Notverified', 'StudentController@Notverified')->name('Notverified');
		Route::get('ArchiveStudent', 'StudentController@ArchiveStudent')->name('ArchiveStudent');
		Route::get('RestoeStudent','StudentController@RestoeStudent')->name('RestoeStudent');
		
		//==============================graduates============================
		 
		Route::resource('graduates', 'GraduateController');
		Route::post('GraduateProcessResult', 'GraduateController@GraduateProcessResult')->name('GraduateProcessResult');
		Route::post('GraduateProcessPay', 'GraduateController@GraduateProcessPay')->name('GraduateProcessPay');
		Route::get('ArchiveGraduate', 'GraduateController@ArchiveGraduate')->name('ArchiveGraduate');
		//==============================subjects============================
		 
		Route::resource('subjects', 'SubjectController');
		//==============================Refunds============================   
		Route::resource('refunds', 'RefundController');
		Route::post('RefundsProcess', 'RefundController@RefundsProcess')->name('RefundsProcess');
		Route::get('ExportRefunds','RefundController@ExportRefunds')->name('ExportRefunds');
		Route::get('RefundsReport', 'RefundController@RefundsReport')->name('RefundsReport');

		//==============================years============================
		 
		Route::resource('years', 'YearController');

		//==============================depts============================

		Route::resource('documents', 'DocumentController');
		Route::post('DocumentPay', 'DocumentController@DocumentPay')->name('DocumentPay');
		Route::post('DocumentProcess', 'DocumentController@DocumentProcess')->name('DocumentProcess');
        Route::get('ArchivDocument', 'DocumentController@ArchivDocument')->name('ArchivDocument');
		Route::get('RestoerDocument','DocumentController@RestoerDocument')->name('RestoerDocument');
		Route::get('DocumentsExport','DocumentController@DocumentsExport')->name('DocumentsExport');
		//==============================students============================

		//Route::view('add_student','livewire.show_Form')->name('add_student');

		//==============================users============================

		Route::resource('users', 'UserController');
		Route::get('logout','UserController@userLogout')->name('userLogout');
		Route::get('/changePassword','UserController@showChangePasswordForm')->name('changePassword');
		Route::post('/changePassword','UserController@changePassword')->name('changePassword');
		Route::get('studentexport','UserController@export')->name('studentexport');
		Route::get('studentimport','UserController@studentimport')->name('studentimport');
		Route::post('studentfileupload','UserController@studentfileupload')->name('studentfileupload');
		//==============================attachment============================ 
		Route::post('Upload_attachment', 'UserController@Upload_attachment')->name('Upload_attachment');
        Route::get('Download_attachment/{user_id}/{filename}', 'UserController@Download_attachment')->name('Download_attachment');
        Route::post('Delete_attachment', 'UserController@Delete_attachment')->name('Delete_attachment');

        //==============================Resul============================

		Route::resource('results', 'ResultController');

		Route::get('/Get_semesters/{id}', 'ResultController@Get_semesters');
        Route::get('/Get_subject/{id}', 'ResultController@Get_subject');





	});