@extends('layouts.master')
@section('css')
    @toastr_css
    <link href="{{ URL::asset('assets/plugins/fileuploads/css/fileupload.css') }}" rel="stylesheet" type="text/css" />
    <!---Internal Fancy uploader css-->
    <link href="{{ URL::asset('assets/plugins/fancyuploder/fancy_fileupload.css') }}" rel="stylesheet" />
@section('title')
{{ trans('Users_trans.edit_user') }}
@stop
@endsection
@section('page-header')
  <!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Users_trans.edit_user') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Users_trans.edit_user') }}</li>
            </ol>
        </div>
    </div>
</div>
 <!-- breadcrumb -->
@endsection
@section('content')
    <!-- row -->
    <div class="row">
        <div class="col-md-12 mb-30">
            <div class="card card-statistics h-100">
                <div class="card-body">

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <a href="{{ route('users.index') }}">
                        <button type="button" class="btn btn-primary l-t-20">
                            {{ trans('main_trans.back') }}
                        </button>
                        <br><br> 
                    </a>
                   
                            {!! Form::model($user, ['method' => 'PATCH','files' => 'ture','route' => ['users.update', $user->id]]) !!}
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>{{ trans('Depts_trans.Name_Dept') }} : <span class="text-danger">*</span></label>
                                        <select name="dept_id" class="custom-select" <select class="custom-select"
                                            aria-label="Default select example" >
                                            <option selected >{{ trans('main_trans.Choose') }}</option>
                                            @foreach($depts as $dept)
                                            <option value='{{ $dept->id}}'{{$dept->id == $user->dept_id ? 'selected' : '' }}> {{ $dept->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group col-md-4">
                                    <label for="title">{{ trans('main_trans.user_type') }}</label>
                                    <select class="custom-select my-1 mr-sm-2" name="user_type">
                                        <option selected disabled>{{ trans('Users_trans.Choose') }}</option>
                                        <option value='emp'{{$user->user_type == 'emp' ? 'selected' : '' }}> {{ trans('main_trans.employee') }}</option>
                                        <option value='stu'{{$user->user_type == 'stu' ? 'selected' : '' }}>{{ trans('main_trans.student') }}</option>
                                        @can('isAdmin')
                                        <option value='admin'{{$user->user_type == 'admin' ? 'selected' : '' }}>{{ trans('main_trans.admin') }}</option>
                                         @endcan
                                    </select>
                                    @error('user_type')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Users_trans.full_name') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="first_name" type="text" value="{{ $user->first_name }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Users_trans.phone') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="phone" type="text" value="{{ $user->phone }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Users_trans.email') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="email" type="text" value="{{ $user->email }}">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label>{{ trans('Users_trans.password') }} : <span class="text-danger">*</span></label>
                                        <input  class="form-control" name="password" type="text" value="">
                                    </div>
                                </div>
                            </div>

                           
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <strong>{{ trans('Users_trans.user_type') }}</strong>
                                        {!! Form::select('roles[]', $roles,$userRole, array('class' => 'form-control','multiple'))
                                        !!}
                                    </div>
                                </div>
                                {{-- <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="bank">{{trans('Certificat_trans.bank')}} : <span class="text-danger">*</span></label>
                                        <input type="file" name="bank" class="dropify"
                                        accept="image/*" data-height="70" />
                                    </div>
                                </div> --}}
                            </div>

                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary btn-lg">{{trans('Certificat_trans.Edit')}}</button>
                            </div>
                            
                        </form>
                        <br><br>
                </div>
            </div>
        </div>
    </div>
    <!-- row closed -->
@endsection
@section('js')
    @toastr_js
    @toastr_render
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fileuploads/js/file-upload.js') }}"></script>
    <!--Internal Fancy uploader js-->
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.ui.widget.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.iframe-transport.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/jquery.fancy-fileupload.js') }}"></script>
    <script src="{{ URL::asset('assets/plugins/fancyuploder/fancy-uploader.js') }}"></script>
@endsection
