@extends('layouts.master')
@section('css')

@section('title')
    {{ trans('Users_trans.add_user') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Users_trans.add_user') }} </h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.user') }}</a></li>
                <li class="breadcrumb-item active">{{ trans('Users_trans.add_user') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
@if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <a href="{{ route('users.index') }}">
        <button type="button" class="button x-small">
            {{trans('main_trans.back') }}
        </button>
        <br><br>
    </a>
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">
                <form action="{{ route('users.store') }}" method="post" enctype="multipart/form-data"
                    autocomplete="off">
                    {{ csrf_field() }}
                    <input type="hidden" name="user_type" value="emp">
                    <div class="col-xs-12">
                   
                        {{-- 1 --}}
                        <div class="form-row">
                            <div class="col">
                                <label for="title">{{ trans('Certificat_trans.First_name') }}</label>
                                <input type="text" name="first_name" class="form-control" value="{{ old('first_name') }}">
                                @error('first_name')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col">
                                <label for="title">{{ trans('Users_trans.email') }}</label>
                                <input type="email" name="email" class="form-control" value="{{ old('email') }}">
                                @error('email')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        {{-- 2 --}}
                       
                        
                        <div class="col-md-12">
                            <br>
                            <div class="form-row">
                                
                                <div class="col">
                                    <label for="title">{{ trans('Users_trans.password') }}</label>
                                    <input type="password" name="password" class="form-control" >
                                    @error('password')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="form-group col-md-4">
                                    <label for="inputCity">{{ trans('Depts_trans.Name_Dept') }}</label>
                                    <select  class="custom-select my-1 mr-sm-2" name="dept_id">
                                        <option selected disabled>{{ trans('Users_trans.Choose') }}...</option>
                                        @foreach ($depts as $dept)
                                            <option value="{{ $dept->id }}">{{ $dept->name }}</option>
                                        @endforeach
                                    </select> 
                                    @error('dept')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="form-group col-md-4">
                                    <label for="title">{{ trans('main_trans.user_type') }}</label>
                                    <select class="custom-select my-1 mr-sm-2" name="user_type">
                                        <option selected disabled>{{ trans('Users_trans.Choose') }}...</option>
                                        <option value="emp">{{ trans('main_trans.employee') }}</option>
                                        <option value="stu">{{ trans('main_trans.student') }}</option>
                                    </select>
                                    @error('user_type')
                                        <div class="alert alert-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>
                        </div>
                           {{-- 3 --}}
                       
                          
                            <div class="form-group">
                                <div class="form-group">
                                    <label class="form-label"> صلاحية المستخدم</label>
                                    {!! Form::select('roles_name[]', $roles, [], ['class' => 'form-control', 'multiple']) !!}
                                </div>
                            </div>

                        </div><br>
                        
                        <div class="d-flex justify-content-center">
                            <button type="submit" class="btn btn-primary">حفظ البيانات</button>
                        </div>
                 </form>
                    </div>
            </div>
        </div>
    </div>
</div>
</div>
<!-- row closed -->
@endsection

@section('js')

<script>
    var date = $('.fc-datepicker').datepicker({
       
        'format': 'yyyy-mm-dd',
    }).val();
</script>

@endsection
