@extends('layouts.master')
@section('css')

@section('title')
        {{ trans('Results_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0">    {{ trans('Results_trans.add_result') }} </h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">Home</a></li>
                <li class="breadcrumb-item active"> {{ trans('Result_trans.title_page') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">
    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">
                  @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

               
                {!! Form::open(['route' => 'results.create','method'=>'POST','autocomplete'=>'off' ]) !!}
                 @csrf
                {{ method_field('get') }}
                  
                  
                        <div class="row">
                          <div class="col-md-3">
                                <label for="inputZip">السنة الدراسية</label>
                                  <select class="custom-select mr-sm-2" name="year_id">
                                        <option selected disabled>{{trans('Results_trans.Choose')}}...</option>
                                       @foreach($years as $year)
                                            <option  value="{{ $year->id }}">{{ $year->name }}</option>
                                        @endforeach
                                </select>
                            </div>
                           <div class="col-md-3">
                                <div class="form-group">
                                    <label for="Grade_id">{{trans('Results_trans.Dept')}} : <span class="text-danger">*</span></label>
                                    <select class="custom-select mr-sm-2" name="dept_id">
                                        <option selected disabled>{{trans('Results_trans.Choose')}}...</option>
                                       @foreach($depts as $dept)
                                            <option  value="{{ $dept->id }}">{{ $dept->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="Classroom_id">{{trans('Results_trans.Semester')}} : <span class="text-danger">*</span></label>
                                    <select class="custom-select mr-sm-2" name="semester_id">
                                     <option selected disabled>{{trans('Results_trans.Choose')}}...</option>
                                        @foreach($semesters as $semester)
                                            <option  value="{{ $semester->id }}">{{ $semester->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="section_id">{{trans('Results_trans.Subject')}} : </label>
                                    <select class="custom-select mr-sm-2" name="subject_id">

                                    </select>
                                </div>
                            </div>
                        </div>

                    <button class="btn btn-success btn-md nextBtn btn-lg pull-right" type="submit">{{trans('Results_trans.Insert')}}</button>
                {!! Form::close() !!}

            </div>

            <div>
              @if ($users->count() > 0)

               <table class="table table-hover">

        <thead>
        <tr> 
            <th>#</th>
            <th>@lang('site.name')</th>
            <th>@lang('site.description')</th>
         
        </tr>
        </thead>
        
        <tbody>
        @foreach ($users as $index=>$user)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ $user->name }}</td>
                <td>{!! $user->email !!}</td>
               
               
            </tr>
        
        @endforeach
        </tbody>

    </table><!-- end of table -->

              @endif
            </div>
        </div>
    </div>
</div>
<!-- row closed -->
@endsection
@section('js')

<script>
    $(document).ready(function () {
        $('select[name="semester_id"]').on('change', function () {
            var semester_id = $(this).val();
            if (semester_id) {
                $.ajax({
                    url: "{{ URL::to('Get_subject') }}/" + semester_id,
                    type: "GET",
                    dataType: "json",
                   success: function (data) {
                        $('select[name="subject_id"]').empty();
                        $.each(data, function (key, value) {
                            $('select[name="subject_id"]').append('<option value="' + key + '">' + value + '</option>');
                        });

                    },
                });
            }

            else {
                console.log('AJAX load did not work');
            }
        });
    });
</script>

@endsection
