@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
{{ trans('Report_trans.title_page') }} - {{ trans('Refund_trans.Refund') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.reports') }} / {{ trans('Refund_trans.Refund') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active">{{ trans('Refund_trans.Refund') }} </li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
               <br>
            </a>
                <div class="table-responsive">
                    <table class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th> {{ trans('Refund_trans.doc') }} </th>
                                <th> {{ trans('Refund_trans.student_name') }} </th>
                                <th>{{trans('Certificat_trans.notification_number')}}</th>
                                <th>{{trans('Certificat_trans.amount')}}</th>
                                <th> {{ trans('Refund_trans.amount2') }} </th>
                                <th>{{ trans('Delivery_trans.request_date') }}</th>
                                <th>{{ trans('Delivery_trans.stauts') }}</th>
                                
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($refunds as $index => $refund)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        @if ($refund->type == '1')
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Certificat') }}
                                        </span>
                                        @elseif ($refund->type == '2')
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Statment') }}
                                        </span>
                                        @elseif ($refund->type == '3')
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Record') }}
                                        </span>
                                        @else
                                        <span class="label text-info">
                                            {{ trans('Refund_trans.Register') }} 
                                        </span>
                                        @endif
                                    </td>
                                    <td>{{ $refund->user->first_name }}</td>
                                    <td>{{ $refund->notification_number }}</td>
                                    <td>{{ $refund->amount }}</td>
                                    <td>{{ $refund->refund }}</td>
                                    <td>{{ $refund->created_at}}</td>
                                    @can('المالية')
                                    <td>
                                        @if ($refund->stutus == '0')
                                            <span class="label text-info">
                                                 {{ trans('Statment_trans.processing') }}
                                            </span>
                                        @elseif ($refund->stutus == '1')
                                        <span class="label text-success">
                                            {{ trans('Statment_trans.complate') }}
                                        </span>
                                        @else
                                        <span class="label text-danger">
                                            {{ trans('Statment_trans.reject') }}
                                        </span>
                                        @endif
                                    </td>
                                    @endcan
                                </tr>
                            @endforeach
                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
