@extends('layouts.master')
@section('css')
    @toastr_css
@section('title')
    {{ trans('Certificat_trans.title_page') }}
@stop
@endsection
@section('page-header')
<!-- breadcrumb -->
<div class="page-title">
    <div class="row">
        <div class="col-sm-6">
            <h4 class="mb-0"> {{ trans('Certificat_trans.reports') }}</h4>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb pt-0 pr-0 float-left float-sm-right ">
                <li class="breadcrumb-item"><a href="#" class="default-color">{{ trans('main_trans.Dashboard') }}</a></li>
                <li class="breadcrumb-item active"> {{ trans('Certificat_trans.reports') }}</li>
            </ol>
        </div>
    </div>
</div>
<!-- breadcrumb -->
@endsection
@section('content')
<!-- row -->
<div class="row">

    <div class="col-md-12 mb-30">
        <div class="card card-statistics h-100">
            <div class="card-body">

                @if ($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                <br><br> 
            </a>
                <div class="table-responsive">
                    <table id="datatable" class="table table-striped table-bordered p-0">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>{{ trans('Certificat_trans.name') }}</th>
                                <th>{{ trans('Depts_trans.Name_Dept') }}</th>
                                <th>{{ trans('Certificat_trans.admission_year') }}</th>
                                <th>{{ trans('Certificat_trans.guraduate_year') }}</th>
                                <th>{{ trans('Certificat_trans.certificat_type') }}</th>
                                <th>{{ trans('Certificat_trans.status') }}</th>
                                <th>{{ trans('Certificat_trans.date') }}</th>
                            </tr>
                        </thead>
                        <tboby>
                            @foreach ($certificats as $index => $certificat)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>{{ $certificat->first_name }} {{ $certificat->second_name }} {{ $certificat->midell_name }} {{ $certificat->last_name }}</td>
                                    
                                    <td>{{ $certificat->dept->name }}</td>
                                    <td>{{ $certificat->admission_year }}</td>
                                    <td>{{ $certificat->guraduate_year }}</td>
                                    <td>
                                        @if ($certificat->certificat_type == '1')
                                                {{ trans('Certificat_trans.Details') }}
                                        @else
                                                {{ trans('Certificat_trans.Regular') }}
                                        @endif
                                    </td>
                                    
                                    <td>
                                        @if ($certificat->status == '0')
                                            <span class="label text-info">
                                                 {{ trans('Certificat_trans.Process') }}
                                            </span>
                                        @elseif ($certificat->status == '1')
                                        <span class="label text-success">
                                            {{ trans('Certificat_trans.complate') }}
                                        </span>
                                        @else
                                            <span class="label text-danger">
                                                {{ trans('Certificat_trans.reject') }}
                                            </span>
                                        @endif
                                    </td>
                                    <td>
                                        {{ date('d-m-y', strtotime($certificat->created_at)) }}
                                     </td>
                                </tr>


    <!-- delete_modal_Subject -->
                                <div class="modal fade" id="delete{{ $certificat->id }}" tabindex="-1" role="dialog"
                                    aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 style="font-family: 'Cairo', sans-serif;" class="modal-title"
                                                    id="exampleModalLabel">
                                                    {{ trans('Certificat_trans.delete_certificat') }}
                                                </h5> 
                                                <button type="button" class="close" data-dismiss="modal"
                                                    aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                {!! Form::open(['route' => ['certificats.destroy', $certificat->id], 'method' => 'DELETE']) !!}
                                                {{ method_field('Delete') }}
                                                @csrf
                                                {{ trans('Certificat_trans.Warning_certificat') }}
                                                <input id="id" type="hidden" name="id" class="form-control"
                                                    value="{{ $certificat->id }}">
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary"
                                                        data-dismiss="modal">{{ trans('Certificat_trans.Close') }}</button>
                                                    <button type="submit"
                                                        class="btn btn-danger">{{ trans('Certificat_trans.Delete') }}</button>
                                                </div>
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </tboby>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- add_modal_Subject 
    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" style="font-family: 'Cairo', sans-serif;" id="exampleModalLabel">
                        {{ trans('subjects_trans.add_Subject') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form action="{{ route('certificats.store') }}" method="POST" autocomplete="off">
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col">
                                <input type="text" name="Name" class="form-control"
                                    placeholder="{{ trans('Subjects_trans.Subject_name_ar') }}">
                            </div>

                            <div class="col">
                                <input type="text" name="Name_en" class="form-control"
                                    placeholder="{{ trans('Subjects_trans.Subject_name_en') }}">
                            </div>

                        </div>
                        <br>


                        <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Name_Dept') }}</label>
                            <select name="dept_id" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار القسم</option>
                                {{-- @foreach ($depts as $dept)
                                    <option value='{{ $dept->id }}'> {{ $dept->name }}</option>
                                @endforeach --}}
                            </select>
                        </div><br>
                       <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Semester_Name') }}</label>
                            <select name="semester_id" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار الفصل الدراسي</option>
                                {{-- @foreach ($semesters as $semester)
                                        <option value='{{ $semester->id }}'> {{ $semester->name }}</option>
                                    @endforeach --}}
                            </select>
                        </div><br>
                        <div class="col">
                            <label for="inputName"
                                class="control-label">{{ trans('Subjects_trans.Subject_hours') }}</label>
                            <select name="hours" class="custom-select" <select class="custom-select"
                                aria-label="Default select example">
                                <option selected>اختيار عدد الساعات</option>
                                <option value='2'> 2</option>
                                <option value='3'> 3</option>
                            </select>
                        </div><br>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal">{{ trans('Subjects_trans.Close') }}</button>
                    <button type="submit" class="btn btn-danger">{{ trans('Subjects_trans.submit') }}</button>
                </div>
                </form>
            </div>
        </div>
    </div>
-->

</div>
<!-- row closed -->
@endsection
@section('js')
@toastr_js
@toastr_render
@endsection
